package eu.dnetlib.data.search.solr;

import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.SecureDriverResource;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by antleb on 2/4/14.
 */
public class SolrResultSetFactory implements ResultSetFactory {

    private Logger logger = Logger.getLogger(getClass());
    private Map<String, CloudSolrClient> clients = new HashMap<String, CloudSolrClient>();

    @Autowired
    private PrometheusMeterRegistry prometheusMeterRegistry;


    @Override
    public ResultSet<String> createResultSet(EPR epr) {
        try {

            String[] zkservers= epr.getAddress().split(",");

            CloudSolrClient solrClient;

            synchronized (clients) {
                solrClient =  clients.get(epr.getAddress());
            }
            if (solrClient == null) {
                solrClient = new CloudSolrClient.Builder().withZkHost(Arrays.asList(zkservers)).build();

                clients.put(epr.getAddress(), solrClient);
            }

            ResultSet<String> solrResultSets = new SolrResultSet(epr, solrClient, prometheusMeterRegistry);

            return solrResultSets;

        } catch (Exception e) {
            logger.warn("Error creating solr client", e);
        }

        logger.debug("NOT HERE!");
        return null;
    }

    @Override
    public <D> ResultSet<D> createResultSet(EPR epr, Class<D> resourceClass) {
        return (ResultSet<D>) createResultSet(epr);
    }

    @Override
    public <D> ResultSet<D> createResultSet(ResultSet<?> rs, Class<D> resourceClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <D extends SecureDriverResource> ResultSet<D> createSecurityAwareRS(EPR epr, Class<D> resourceClass) {
        throw new UnsupportedOperationException();
    }
}
