package eu.dnetlib.data.search.web.api;

import io.micrometer.prometheus.PrometheusMeterRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Controller
@ComponentScan
@Component
public class MicrometerPublisher {

    @Autowired
    PrometheusMeterRegistry registry;

    @RequestMapping(method = RequestMethod.GET, value = "/metrics", produces = {MediaType.TEXT_PLAIN_VALUE})
    @ResponseBody
    public String getMetrics(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return  registry.scrape();
    }
}
