package eu.dnetlib.data.search.web.utils;

import java.util.Arrays;
import java.util.List;

/**
 * Created by kiatrop on 19/9/2016.
 */
public class RequestResponseHandler {

    public enum Entity {
        RESULT("result"),
        PUBLICATION("publication"),
        DATASET("dataset"),
        PROJECT("project"),
        DATASOURCE("datasource"),
        ORGANIZATION("organization"),
        //PERSON("person"),
        SOFTWARE("software"),
        OTHER("other"),
        NONE("");

        private final List<String> RESULT_FIELD_QUERIES = Arrays.asList("oaftype exact result");
        private final List<String> PUBLICATION_FIELD_QUERIES = Arrays.asList("oaftype exact result", "resulttypeid exact publication");
        private final List<String> DATASET_FIELD_QUERIES = Arrays.asList("oaftype exact result", "resulttypeid exact dataset");
        private final List<String> SOFTWARE_FIELD_QUERIES = Arrays.asList("oaftype exact result", "resulttypeid exact software");
        private final List<String> OTHER_FIELD_QUERIES = Arrays.asList("oaftype exact result", "resulttypeid exact other");
        private final List<String> PROJECT_FIELD_QUERIES = Arrays.asList("oaftype exact project");
        private final List<String> DATASOURCE_FIELD_QUERIES = Arrays.asList("oaftype exact datasource", "(datasourcecompatibilityid <> \"UNKNOWN\")");
        private final List<String> ORGANIZATION_FIELD_QUERIES = Arrays.asList("oaftype exact organization");
        /*private final List<String> ORGANIZATION_FIELD_QUERIES = Arrays.asList("oaftype exact organization",
                "reldatasourcecompatibilityid exact driver or reldatasourcecompatibilityid exact driver-openaire2.0 or " +
                "reldatasourcecompatibilityid exact openaire2.0 or reldatasourcecompatibilityid exact openaire3.0 or " +
                "reldatasourcecompatibilityid exact openaire2.0_data or reldatasourcecompatibilityid exact hostedBy or relproject=*");
        */
        //private final List<String> PERSON_FIELD_QUERIES = Arrays.asList("oaftype exact person");

        private final String RESULT_QUERY = "oaftype exact result";
        private final String PUBLICATION_QUERY = "resulttypeid exact publication";
        private final String DATASET_QUERY = "resulttypeid exact dataset";
        private final String SOFTWARE_QUERY = "resulttypeid exact software";
        private final String OTHER_QUERY = "resulttypeid exact other";

        private String value;
        Entity(String value) {
            this.value = value;
        }
        private String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return this.getValue();
        }

        public String getQueryPrefix() {
            switch (this) {
                case RESULT:
                    return RESULT_PREFIX;

                case PUBLICATION:
                    return PUBLICATION_PREFIX;

                case DATASET:
                    return DATASET_PREFIX;

                case SOFTWARE:
                    return SOFTWARE_PREFIX;

                case OTHER:
                    return OTHER_PREFIX;

                case PROJECT:
                    return PROJECT_PREFIX;

                case DATASOURCE:
                    return DATASOURCE_PREFIX;

                case ORGANIZATION:
                    return ORGANIZATION_PREFIX;

                //case PERSON:
                //    return PERSON_PREFIX;

                case NONE:
                    return "";

                default:
                    throw new IllegalArgumentException();
            }

        }

        public String getPlural() {
            switch (this) {
                case RESULT:
                    return "results";

                case PUBLICATION:
                    return "publications";

                case DATASET:
                    return "datasets";

                case SOFTWARE:
                    return "software";

                case OTHER:
                    return "other";

                case PROJECT:
                    return "projects";

                case DATASOURCE:
                    return "datasources";

                case ORGANIZATION:
                    return "organizations";

                //case PERSON:
                //    return "people";

                case NONE:
                    return "resources";

                default:
                    throw new IllegalArgumentException();
            }
        }

        public List<String> getFieldQueries() {
            switch (this) {
                case RESULT:
                    return RESULT_FIELD_QUERIES;

                case PUBLICATION:
                    return PUBLICATION_FIELD_QUERIES;

                case DATASET:
                    return DATASET_FIELD_QUERIES;

                case SOFTWARE:
                    return SOFTWARE_FIELD_QUERIES;

                case OTHER:
                    return OTHER_FIELD_QUERIES;

                case PROJECT:
                    return PROJECT_FIELD_QUERIES;

                case DATASOURCE:
                    return DATASOURCE_FIELD_QUERIES;

                case ORGANIZATION:
                    return ORGANIZATION_FIELD_QUERIES;

                //case PERSON:
                //    return PERSON_FIELD_QUERIES;

                default:
                    throw new IllegalArgumentException();
            }
        }

        public String getSimpleQuery() {
            switch (this) {
                case RESULT:
                    return RESULT_QUERY;

                case PUBLICATION:
                    return PUBLICATION_QUERY;

                case DATASET:
                    return DATASET_QUERY;

                case SOFTWARE:
                    return SOFTWARE_QUERY;

                case OTHER:
                    return OTHER_QUERY;

                default:
                    throw new IllegalArgumentException();
            }
        }
    }

    public final static String RESULT_PREFIX = "(oaftype exact result)";
    public final static String PUBLICATION_PREFIX = "(oaftype exact result) and (resulttypeid exact publication)";
    public final static String DATASET_PREFIX = "(oaftype exact result) and (resulttypeid exact dataset)";
    public final static String SOFTWARE_PREFIX = "(oaftype exact result) and (resulttypeid exact software)";
    public final static String OTHER_PREFIX = "(oaftype exact result) and (resulttypeid exact other)";
    public final static String PROJECT_PREFIX = "(oaftype exact project)";
    public final static String DATASOURCE_PREFIX = "(oaftype exact datasource) and (datasourcecompatibilityid <> \"UNKNOWN\")";
    public final static String ORGANIZATION_PREFIX = "(oaftype exact organization and " +
            "(reldatasourcecompatibilityid=driver or reldatasourcecompatibilityid=driver-openaire2.0 or " +
            "reldatasourcecompatibilityid=openaire2.0 or reldatasourcecompatibilityid=openaire3.0 or " +
            "reldatasourcecompatibilityid=openaire2.0_data or reldatasourcecompatibilityid=hostedBy " +
            "or relproject=*)";
    //public final static String PERSON_PREFIX = "(oaftype exact person)";



}
