<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns="http://namespace.openaire.eu/sygma">

    <xsl:output method="xml" indent="yes" encoding="UTF-8"/>

    <xsl:template match = "/">
        <response>
            <xsl:apply-templates select="response/header"/>
            <datasets>
                <xsl:apply-templates select="//result"/>
            </datasets>
        </response>
    </xsl:template>

    <xsl:template match="response/header">
        <header>
            <size><xsl:value-of select="size"/></size>
            <page><xsl:value-of select="page"/></page>
            <total><xsl:value-of select="total"/></total>
        </header>
    </xsl:template>

<!--    <xsl:template match="field[@name='pid']/field[@name='classid' and @value='doi']" name="idnode"></xsl:template> -->

    <xsl:template match="result">
        <dataset>
            <openaireid><xsl:value-of select="field[@name='resultId']/@value"/></openaireid>
            <authors>
                <xsl:for-each select="field[@name='hasAuthor']">
                    <author><xsl:value-of select="field[@name='fullname']/@value"/></author>
                </xsl:for-each>
            </authors>
            <xsl:for-each select="field[@name='pid']">
                <xsl:if test="field[@name='classid' and @value='doi']/@value = 'doi'">
                    <doi>
                        <xsl:value-of select="field[@name='value']/@value"/>
                    </doi>
                </xsl:if>
            </xsl:for-each>
            <description><xsl:value-of select="field[@name='description']/@value"/></description>
            <title><xsl:value-of select="field[@name='title']/@value"/></title>
            <xsl:for-each select="field[@name='datasource']">
                <xsl:for-each select="field[@name='url']">
                    <webresource><xsl:value-of select="@value"/></webresource>
                </xsl:for-each>
            </xsl:for-each>
            <bestlicense><xsl:value-of select="field[@name='bestaccessright']/@value"/></bestlicense>
            <relatedpublications>
                    <xsl:for-each select="field[@name='isRelatedTo']">
                        <xsl:if test="field[@name='resulttypeid']/@value = 'publication'">
                            <publication>
                                <openaireid><xsl:value-of select="field['resultid']/@value"/></openaireid>
                                <doi></doi>
                                <title><xsl:value-of select="field[@name='title']/@value"/></title>
                                <authors></authors>
                                <sourcejournal></sourcejournal>
                                <dateofacceptance></dateofacceptance>
                                <webresource></webresource>
                                <bestlicense></bestlicense>
                            </publication>
                        </xsl:if>
                    </xsl:for-each>
            </relatedpublications>
        </dataset>
    </xsl:template>

</xsl:stylesheet>