/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.actions;

import com.opensymphony.xwork2.ActionSupport;
import eu.dnetlib.validator.admin.api.UserApi;
import eu.dnetlib.validator.admin.api.ValidatorAdminAPI;
import eu.dnetlib.validator.commons.email.Emailer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BaseValidatorAction
extends ActionSupport {
    private static final long serialVersionUID = -622158192564945303L;
    private UserApi userAPI = null;
    private ValidatorAdminAPI validatorAdminAPI = null;
    private Emailer emailer = null;
    public static String loggedInField = "LOGGED_IN_FIELD";
    private String valBaseUrl = null;
    private String valAdminEmail = null;
    private String userMode = null;
    private String repoMode = null;
    private String deployEnvironment = null;

    public void reportException(Exception exception) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        exception.printStackTrace(printWriter);
        ArrayList<String> recipients = new ArrayList<String>();
        try {
            recipients.add(this.getValAdminEmail());
            String message = "An exception has occurred:\n" + ((Object)writer).toString();
            String subject = "Automatic Bug Report";
            this.getEmailer().sendMail(recipients, subject, message, false, null);
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(BaseValidatorAction.class);
            logger.error((Object)"error sending error report", (Throwable)e);
        }
    }

    public boolean isModeLdap() {
        return this.userMode.trim().toLowerCase().equals("ldap");
    }

    public boolean isModeOpenAIRE() {
        return this.repoMode.trim().toLowerCase().equals("dnet");
    }

    public UserApi getUserAPI() {
        return this.userAPI;
    }

    public void setUserAPI(UserApi userAPI) {
        this.userAPI = userAPI;
    }

    public ValidatorAdminAPI getValidatorAdminAPI() {
        return this.validatorAdminAPI;
    }

    public void setValidatorAdminAPI(ValidatorAdminAPI validatorAdminAPI) {
        this.validatorAdminAPI = validatorAdminAPI;
    }

    public Emailer getEmailer() {
        return this.emailer;
    }

    public void setEmailer(Emailer emailer) {
        this.emailer = emailer;
    }

    public String getUserMode() {
        return this.userMode;
    }

    public void setUserMode(String userMode) {
        this.userMode = userMode;
    }

    public String getRepoMode() {
        return this.repoMode;
    }

    public void setRepoMode(String repoMode) {
        this.repoMode = repoMode;
    }

    public void setValBaseUrl(String valBaseUrl) {
        this.valBaseUrl = valBaseUrl;
    }

    public String getValBaseUrl() {
        return this.valBaseUrl;
    }

    public void setValAdminEmail(String valAdminEmail) {
        this.valAdminEmail = valAdminEmail;
    }

    public String getValAdminEmail() {
        return this.valAdminEmail;
    }

    public String getDeployEnvironment() {
        return this.deployEnvironment;
    }

    public void setDeployEnvironment(String deployEnvironment) {
        this.deployEnvironment = deployEnvironment;
    }
}

