/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.actions.login;

import eu.dnetlib.validator.admin.actions.BaseValidatorAction;
import eu.dnetlib.validator.admin.config.Constants;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.SessionAware;

public class Login
extends BaseValidatorAction
implements SessionAware,
ServletResponseAware {
    private static final long serialVersionUID = -6021271413570776229L;
    private String email_username;
    private String password_login;
    private boolean rememberme;
    private Map<String, Object> session;
    private HttpServletResponse response;
    private String url;
    private String params;
    private transient Logger logger = Logger.getLogger(Login.class);

    public String execute() {
        this.clearErrorsAndMessages();
        try {
            if (this.email_username == null || this.email_username.trim().equals("")) {
                return "login";
            }
            this.logger.debug((Object)("logging-in user " + this.getEmail()));
            this.session.put(Constants.loggedInField, this.getEmail());
            this.session.put("email", this.getEmail());
            if (this.getUserAPI().isAdmin(this.email_username) || this.getValidatorAdminAPI().userIsMasterAdmin(this.email_username)) {
                this.session.put("isAdmin", "true");
            }
            if (this.getValidatorAdminAPI().userIsMasterAdmin(this.email_username)) {
                this.session.put("isAdmin", "true");
            }
            if (this.getValidatorAdminAPI().userIsSecondaryAdmin(this.email_username)) {
                this.session.put("isAdmin", "true");
            }
            this.addActionMessage("Logged-in successfully");
            if (this.url != null && (this.url.equals("/go2login") || this.url.equals("/Login") || this.url.equals("/portalLogin"))) {
                this.url = "";
                return "welcome";
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error((Object)("error logging-in user " + this.getEmail()), (Throwable)e);
            this.addActionError(this.getText("generic.error"));
            this.reportException(e);
            return "exception";
        }
    }

    public void validate() {
        this.clearErrors();
        try {
            if (this.email_username == null || this.email_username.trim().equals("")) {
                return;
            }
            String username = this.email_username;
            Pattern rfc2822 = Pattern.compile("^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$");
            if (!rfc2822.matcher(this.getEmail().trim().toLowerCase()).matches()) {
                this.logger.debug((Object)"user logged in using username");
                this.email_username = this.getUserAPI().getEmailFromUsername(this.getEmail());
            }
            if (this.email_username == null) {
                this.email_username = username;
                this.addActionError(this.getText("login.userNotExists"));
                return;
            }
            if (!this.getUserAPI().userExists(this.getEmail())) {
                this.email_username = username;
                this.addActionError(this.getText("login.userNotExists"));
                return;
            }
            if (!this.getUserAPI().isUserActivated(this.getEmail())) {
                this.email_username = username;
                this.addActionError(this.getText("login.notActivated"));
                return;
            }
            if (!this.getUserAPI().correctCreds(this.getEmail(), this.getPassword_login())) {
                this.email_username = username;
                this.addActionError(this.getText("login.incorrectCreds"));
                return;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            this.addActionError(e.toString());
            this.reportException(e);
        }
    }

    public String getEmail() {
        return this.email_username;
    }

    public void setEmail_username(String email_username) {
        this.email_username = email_username;
    }

    public String getPassword_login() {
        return this.password_login;
    }

    public void setPassword_login(String password_login) {
        this.password_login = password_login;
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
    }

    public void setRememberme(boolean rememberme) {
        this.rememberme = rememberme;
    }

    public boolean isRememberme() {
        return this.rememberme;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public HttpServletResponse getServletResponse() {
        return this.response;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }
}

