/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.actions.rules;

import eu.dnetlib.domain.functionality.validator.Rule;
import eu.dnetlib.validator.admin.actions.BaseValidatorAction;
import eu.dnetlib.validator.admin.actions.rules.FieldPair;
import eu.dnetlib.validator.admin.api.ValidatorAdminException;
import eu.dnetlib.validator.admin.constants.TypesAndTableNames;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PrepareEditRule
extends BaseValidatorAction {
    private static final long serialVersionUID = 8825889540939707747L;
    private int ruleId;
    private Rule rule;
    private List<Rule> rules;
    private List<FieldPair> ruleValues;
    private Set<String> entityTypes;
    private String funct = null;
    private static final Logger logger = Logger.getLogger(PrepareEditRule.class);

    public String execute() {
        this.clearErrorsAndMessages();
        try {
            this.entityTypes = TypesAndTableNames.getCrisEntities().keySet();
            logger.debug((Object)("preparing edit of rule " + this.ruleId));
            this.rule = this.getValidatorAdminAPI().getRule(this.ruleId);
            this.ruleValues = this.getValidatorAdminAPI().getRuleValuePairs(this.rule);
            if (this.rule.getType().equals("ChainRule")) {
                try {
                    this.rules = this.getValidatorAdminAPI().getAllRules();
                }
                catch (ValidatorAdminException e) {
                    return "error";
                }
            }
            logger.debug((Object)("ruleType: " + this.rule.getType()));
            this.rule.setJob_type((String)TypesAndTableNames.jobTypes.get(this.rule.getJob_type()));
            return "success";
        }
        catch (Exception e) {
            logger.error((Object)("preparing edit of rule " + this.ruleId), (Throwable)e);
            this.addActionError(this.getText("generic.error"));
            this.reportException(e);
            return "exception";
        }
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public List<FieldPair> getRuleValues() {
        return this.ruleValues;
    }

    public void setRuleValues(List<FieldPair> ruleValues) {
        this.ruleValues = ruleValues;
    }

    public int getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(int ruleId) {
        this.ruleId = ruleId;
    }

    public String getFunct() {
        return this.funct;
    }

    public void setFunct(String funct) {
        this.funct = funct;
    }

    public Set<String> getEntityTypes() {
        return this.entityTypes;
    }

    public void setEntityTypes(Set<String> entityTypes) {
        this.entityTypes = entityTypes;
    }
}

