/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.actions.users;

import eu.dnetlib.validator.admin.actions.BaseValidatorAction;
import org.apache.log4j.Logger;

public class ActivateAccount
extends BaseValidatorAction {
    private static final long serialVersionUID = 4680016183168923054L;
    private Logger logger = Logger.getLogger(ActivateAccount.class);
    private String activationId;

    public String execute() {
        this.clearErrorsAndMessages();
        try {
            this.logger.debug((Object)("activating user account with activation id " + this.activationId));
            if (this.getUserAPI().activateUser(this.getActivationId())) {
                this.addActionMessage(this.getText("registration.okAccountActivation"));
            } else {
                this.addActionMessage(this.getText("registration.okAccountAlreadyActivation"));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error((Object)("error activating user account with activation id " + this.activationId), (Throwable)e);
            this.addActionError(this.getText("generic.error"));
            this.reportException(e);
            return "exception";
        }
    }

    public void validate() {
        this.clearErrors();
        if (this.getActivationId() == null || this.getActivationId().length() == 0) {
            this.addActionError(this.getText("noActivationId"));
            return;
        }
    }

    public String getActivationId() {
        return this.activationId;
    }

    public void setActivationId(String activationId) {
        this.activationId = activationId;
    }
}

