/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.constants;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class TypesAndTableNames {
    private static Logger logger = Logger.getLogger(TypesAndTableNames.class);
    static HashMap<String, String> ruleTypeToTableNames;
    static HashMap<String, String> crisEntities;
    public static List<String> deployEnvironments;
    public static HashMap<String, String> jobTypes;

    public static String getSetOfEntity(String entity) {
        return (String)crisEntities.get(entity);
    }

    public static HashMap<String, String> getCrisEntities() {
        return crisEntities;
    }

    public static Set<String> getJobTypes() {
        logger.debug((Object)"getting all types of jobs");
        return new HashSet<String>(jobTypes.values());
    }

    public static void setJobTypes(HashMap<String, String> jobTypes) {
        TypesAndTableNames.jobTypes = jobTypes;
    }

    public static Set<String> getRuleTypes() {
        logger.debug((Object)"getting all types of rules");
        return ruleTypeToTableNames.keySet();
    }

    public static String getTableNameOfType(String type) {
        logger.debug((Object)("getting tableName of rule type " + type));
        return (String)ruleTypeToTableNames.get(type);
    }

    static {
        logger.debug((Object)"initializing the TableNames map");
        ruleTypeToTableNames = new HashMap();
        ruleTypeToTableNames.put("ChainRule", "chain_rule");
        ruleTypeToTableNames.put("OAIPMH Date Granularity", "oaipmhdategranularity_rule");
        ruleTypeToTableNames.put("OAIPMH Embargo Date Check", "oaipmhembargodate_rule");
        ruleTypeToTableNames.put("OAIPMH Incremental Record Delivery", "oaipmhincrementalrecorddelivery_rule");
        ruleTypeToTableNames.put("OAIPMH Resumption Token Duration Check", "oaipmhresumptiontokenduration_rule");
        ruleTypeToTableNames.put("XML Cardinality", "xmlcardinality_rule");
        ruleTypeToTableNames.put("XML Field Exists", "xmlfieldexist_rule");
        ruleTypeToTableNames.put("XML Not Confused Fields", "xmlnotconfusedfields_rule");
        ruleTypeToTableNames.put("XML Regular Expression", "xmlregularexpression_rule");
        ruleTypeToTableNames.put("XML Valid Url", "xmlvalidurl_rule");
        ruleTypeToTableNames.put("XML Vocabulary", "xmlvocabulary_rule");
        ruleTypeToTableNames.put("XML Cris Class Vocabulary", "xmlcrisclassvocabulary_rule");
        ruleTypeToTableNames.put("XML CRIS Referential Integrity Rule", "xmlcrisreferentialintegrity_rule");
        crisEntities = new HashMap();
        crisEntities.put("Publication", "openaire_cris_publications");
        crisEntities.put("Person", "openaire_cris_persons");
        crisEntities.put("Organisation", "openaire_cris_orgunits");
        crisEntities.put("Project", "openaire_cris_projects");
        crisEntities.put("Funding", "openaire_cris_funding");
        crisEntities.put("Service", "openaire_cris_services");
        crisEntities.put("Product", "openaire_cris_datasets");
        jobTypes = new HashMap();
        jobTypes.put("usage", "OAI Usage");
        jobTypes.put("content", "OAI Content");
        deployEnvironments = new ArrayList();
        deployEnvironments.add("openaire-production");
        deployEnvironments.add("openaire-beta");
        deployEnvironments.add("development");
        deployEnvironments.add("lareferencia");
        deployEnvironments.add("mincyt");
    }
}

