/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.actions.login;

import eu.dnetlib.validator.admin.actions.BaseValidatorAction;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SendPassword
extends BaseValidatorAction {
    private static final long serialVersionUID = 7540821478579531671L;
    private Logger logger = Logger.getLogger(SendPassword.class);
    private String email;

    public String execute() {
        this.clearErrorsAndMessages();
        try {
            this.logger.debug((Object)("sending password to user " + this.email));
            ArrayList<String> to = new ArrayList<String>();
            to.add(this.getEmail());
            String securityCode = this.getUserAPI().prepareResetPassword(this.getEmail());
            this.getEmailer().sendMail(to, this.getText("forgotPassword.mail.Subject"), this.getText("forgotPassword.mail.Body1") + ": " + this.getValBaseUrl() + "/resetPassword.action?securityCode=" + securityCode + "\n\n" + this.getText("forgotPassword.mail.Body2") + ": " + securityCode, false, null);
            this.addActionMessage(this.getText("forgotPassword.message"));
            return "success";
        }
        catch (Exception e) {
            this.logger.error((Object)("error sending password to user " + this.email), (Throwable)e);
            this.addActionError(this.getText("generic.error"));
            return "exception";
        }
    }

    public void validate() {
        this.clearErrors();
        try {
            if (!this.getUserAPI().userExists(this.getEmail())) {
                this.addActionError(this.getText("login.userNotExists"));
                return;
            }
        }
        catch (Exception e) {
            this.addActionError(e.toString());
        }
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

