/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.api.impls;

import eu.dnetlib.domain.functionality.validator.CustomProperties;
import eu.dnetlib.domain.functionality.validator.Rule;
import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.validator.admin.actions.rules.FieldPair;
import eu.dnetlib.validator.admin.api.ValidatorAdminAPI;
import eu.dnetlib.validator.admin.api.ValidatorAdminException;
import eu.dnetlib.validator.admin.api.impls.EmailBuilder;
import eu.dnetlib.validator.admin.constants.FieldNames;
import eu.dnetlib.validator.admin.constants.FieldsAndDetails;
import eu.dnetlib.validator.admin.constants.TypesAndTableNames;
import eu.dnetlib.validator.admin.constants.fielddetails.FieldDetails;
import eu.dnetlib.validator.commons.dao.jobs.JobsDAO;
import eu.dnetlib.validator.commons.dao.rules.RulesDAO;
import eu.dnetlib.validator.commons.dao.rules.RulesetsDAO;
import eu.dnetlib.validator.commons.dao.users.UsersDAO;
import eu.dnetlib.validator.commons.email.Emailer;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRED)
public class ValidatorAdminApiImpl
implements ValidatorAdminAPI {
    private JobsDAO jobsDao;
    private RulesetsDAO rulesetsDao;
    private RulesDAO rulesDao;
    private UsersDAO usersDao;
    private EmailBuilder emailBuilder;
    private Emailer emailer = null;
    private List<String> masterAdmins = new ArrayList();
    private List<String> secondaryAdmins = new ArrayList();
    private String registrationsReportEmail;
    private static Logger logger = Logger.getLogger(ValidatorAdminApiImpl.class);

    public void start() {
    }

    public Rule getRule(int ruleId) throws ValidatorAdminException {
        try {
            logger.debug((Object)("getting rule with id: " + ruleId));
            return (Rule)this.rulesDao.get(ruleId);
        }
        catch (Exception e) {
            logger.error((Object)"Error getting rule ", (Throwable)e);
            throw new ValidatorAdminException((Throwable)e);
        }
    }

    public List<FieldPair> getRuleValuePairs(Rule rule) throws ValidatorAdminException {
        try {
            logger.debug((Object)"getting rule value pairs");
            boolean forUsage = false;
            if (rule.getJob_type().equals("usage")) {
                forUsage = true;
            }
            List labels = this.getRuleLabels(rule.getType(), Boolean.valueOf(forUsage), Boolean.valueOf(rule.isFor_cris()));
            ArrayList<FieldPair> ruleValues = new ArrayList<FieldPair>();
            for (String fieldName : labels) {
                FieldPair pair = new FieldPair();
                pair.setFieldName(fieldName);
                if (fieldName.split("\\.")[1].equals(FieldNames.RULE_NAME)) {
                    pair.setFieldValue(rule.getName());
                } else if (fieldName.split("\\.")[1].equals(FieldNames.RULE_DESCRIPTION)) {
                    pair.setFieldValue(rule.getDescription());
                } else if (fieldName.split("\\.")[1].equals(FieldNames.RULE_MANDATORY)) {
                    pair.setFieldValue(Boolean.toString(rule.isMandatory()));
                } else if (fieldName.split("\\.")[1].equals(FieldNames.RULE_WEIGHT)) {
                    pair.setFieldValue(Integer.toString(rule.getWeight()));
                } else if (fieldName.split("\\.")[1].equals(FieldNames.RULE_PROVIDER_INFORMATION)) {
                    pair.setFieldValue(rule.getProvider_information());
                } else {
                    pair.setFieldValue(rule.getConfiguration().getProperty(fieldName.split("\\.")[1]));
                }
                logger.debug((Object)("getting rule value pairs-addpair: " + fieldName + "-" + rule.getConfiguration().getProperty(fieldName.split("\\.")[1])));
                ruleValues.add(pair);
            }
            return ruleValues;
        }
        catch (Exception e) {
            logger.error((Object)"Error getting ruleValue pairs", (Throwable)e);
            throw new ValidatorAdminException((Throwable)e);
        }
    }

    public List<Rule> getAllRules() throws ValidatorAdminException {
        try {
            logger.debug((Object)"getting all rules ");
            return this.rulesDao.getAllRules();
        }
        catch (Exception e) {
            logger.error((Object)"Error getting all rules  to rule pair", (Throwable)e);
            throw new ValidatorAdminException((Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public String storeRule(Rule rule, String[] inputs, Boolean updateExisting) throws ValidatorAdminException {
        try {
            int i;
            logger.debug((Object)"edit rule using the inputs of the user");
            ArrayList<String> fields = new ArrayList<String>();
            List generalFields = FieldsAndDetails.getFieldsAndDetails((String)"Rules");
            List usageFields = FieldsAndDetails.getFieldsAndDetails((String)"usage_rules");
            List crisFields = FieldsAndDetails.getFieldsAndDetails((String)"cris_rules");
            List subFields = FieldsAndDetails.getFieldsAndDetails((String)TypesAndTableNames.getTableNameOfType((String)rule.getType()));
            for (FieldDetails field : generalFields) {
                if (!field.isForDet() || field.getFieldName().equals(FieldNames.RULE_TYPE) || field.getFieldName().equals(FieldNames.RULE_JOBTYPE)) continue;
                fields.add(field.getFieldName());
            }
            if (subFields != null) {
                for (FieldDetails field : subFields) {
                    if (!field.isForDet()) continue;
                    fields.add(field.getFieldName());
                }
            }
            if (rule.getJob_type().toLowerCase().contains("usage")) {
                for (FieldDetails field : usageFields) {
                    if (!field.isForDet()) continue;
                    fields.add(field.getFieldName());
                }
            }
            if (rule.isFor_cris()) {
                for (FieldDetails field : crisFields) {
                    if (!field.isForDet()) continue;
                    fields.add(field.getFieldName());
                }
            }
            CustomProperties pros = new CustomProperties();
            logger.debug((Object)("Fields: " + fields));
            for (i = 0; i < inputs.length; ++i) {
                logger.debug((Object)("input-" + i + " : " + inputs[i]));
            }
            for (i = 0; i < inputs.length; ++i) {
                String line;
                BufferedReader bf;
                logger.debug((Object)("Field: " + (String)fields.get(i) + " - input: " + inputs[i]));
                if (((String)fields.get(i)).equals(FieldNames.RULE_NAME)) {
                    rule.setName(inputs[i]);
                    continue;
                }
                if (((String)fields.get(i)).equals(FieldNames.RULE_DESCRIPTION)) {
                    rule.setDescription(inputs[i]);
                    continue;
                }
                if (((String)fields.get(i)).equals(FieldNames.RULE_MANDATORY)) {
                    rule.setMandatory(Boolean.parseBoolean(inputs[i]));
                    continue;
                }
                if (((String)fields.get(i)).equals(FieldNames.RULE_WEIGHT)) {
                    rule.setWeight(Integer.parseInt(inputs[i]));
                    continue;
                }
                if (((String)fields.get(i)).equals(FieldNames.RULE_PROVIDER_INFORMATION)) {
                    rule.setProvider_information(inputs[i]);
                    continue;
                }
                if (((String)fields.get(i)).equals(FieldNames.RULE_CRIS_ENTITY)) {
                    rule.setEntity_type(inputs[i]);
                    continue;
                }
                if (((String)fields.get(i)).equals(FieldNames.RULE_VOCABULARY_WORDS)) {
                    String words = "";
                    bf = new BufferedReader(new StringReader(inputs[i]));
                    while ((line = bf.readLine()) != null) {
                        words = words + ",";
                        words = words + line;
                    }
                    words = words.substring(1);
                    pros.setProperty((String)fields.get(i), words);
                    continue;
                }
                if (((String)fields.get(i)).equals(FieldNames.RULE_NOTCONNFUSEDFIELDS)) {
                    String ncfields = "";
                    bf = new BufferedReader(new StringReader(inputs[i]));
                    while ((line = bf.readLine()) != null) {
                        ncfields = ncfields + line + "\n";
                    }
                    ncfields = ncfields.substring(0, ncfields.lastIndexOf(10));
                    pros.setProperty((String)fields.get(i), ncfields);
                    continue;
                }
                pros.setProperty((String)fields.get(i), inputs[i]);
            }
            rule.setConfiguration(pros);
            if (!updateExisting.booleanValue()) {
                rule.setId(-1);
            }
            this.rulesDao.save((Object)rule);
            return null;
        }
        catch (Exception e) {
            logger.error((Object)"Error storing rule", (Throwable)e);
            throw new ValidatorAdminException((Throwable)e);
        }
    }

    public List<String> getRuleLabels(String ruleType, Boolean forUsage, Boolean forCris) throws ValidatorAdminException {
        try {
            logger.debug((Object)("getting rule labels for type " + ruleType));
            ArrayList<String> labels = new ArrayList<String>();
            List generalFields = FieldsAndDetails.getFieldsAndDetails((String)"Rules");
            List usageFields = FieldsAndDetails.getFieldsAndDetails((String)"usage_rules");
            List crisFields = FieldsAndDetails.getFieldsAndDetails((String)"cris_rules");
            List subFields = FieldsAndDetails.getFieldsAndDetails((String)TypesAndTableNames.getTableNameOfType((String)ruleType));
            for (FieldDetails field : generalFields) {
                if (!field.isForDet() || field.getFieldName().equals(FieldNames.RULE_TYPE) || field.getFieldName().equals(FieldNames.RULE_JOBTYPE)) continue;
                labels.add(field.getTableName() + "." + field.getFieldName());
            }
            if (subFields != null) {
                for (FieldDetails field : subFields) {
                    if (!field.isForDet()) continue;
                    labels.add(field.getTableName() + "." + field.getFieldName());
                }
            }
            if (forUsage.booleanValue()) {
                for (FieldDetails field : usageFields) {
                    if (!field.isForDet()) continue;
                    labels.add(field.getTableName().split("_")[1] + "." + field.getFieldName());
                }
            }
            if (forCris.booleanValue()) {
                for (FieldDetails field : crisFields) {
                    if (!field.isForDet()) continue;
                    labels.add(field.getTableName().split("_")[1] + "." + field.getFieldName());
                }
            }
            return labels;
        }
        catch (Exception e) {
            logger.error((Object)("getting rule labels for type " + ruleType), (Throwable)e);
            throw new ValidatorAdminException((Throwable)e);
        }
    }

    public List<RuleSet> getRuleSets() throws ValidatorAdminException {
        try {
            logger.debug((Object)"Getting all rule sets");
            return this.rulesetsDao.getRuleSets();
        }
        catch (Exception e) {
            logger.error((Object)"Error getting all rule sets", (Throwable)e);
            throw new ValidatorAdminException((Throwable)e);
        }
    }

    public String deleteRule(int ruleId) throws ValidatorAdminException {
        try {
            logger.debug((Object)("deleting rule with id " + ruleId));
            return this.rulesDao.delete(ruleId);
        }
        catch (Exception e) {
            logger.error((Object)("Error deleting rule with id " + ruleId), (Throwable)e);
            throw new ValidatorAdminException((Throwable)e);
        }
    }

    public RuleSet getRuleSet(int setId) throws ValidatorAdminException {
        try {
            logger.debug((Object)("getting ruleSet with id: " + setId));
            return (RuleSet)this.rulesetsDao.get(setId);
        }
        catch (Exception e) {
            logger.error((Object)("Error getting ruleSet with id: " + setId), (Throwable)e);
            throw new ValidatorAdminException((Throwable)e);
        }
    }

    public void storeRuleSet(RuleSet ruleSet, boolean updateExisting) throws ValidatorAdminException {
        try {
            if (updateExisting) {
                logger.debug((Object)("editing rule set " + ruleSet.getId()));
            } else {
                logger.debug((Object)("creating rule set " + ruleSet.getName()));
            }
            this.rulesetsDao.save((Object)ruleSet);
        }
        catch (Exception e) {
            logger.error((Object)("Error storing ruleSet " + ruleSet.getName()), (Throwable)e);
            throw new ValidatorAdminException((Throwable)e);
        }
    }

    public void deleteRuleSet(int setId) throws ValidatorAdminException {
        try {
            logger.debug((Object)("deleting rule set " + setId));
            this.rulesetsDao.delete(setId);
        }
        catch (Exception e) {
            logger.error((Object)("Error deleting rule set " + setId), (Throwable)e);
            throw new ValidatorAdminException((Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public int deleteOldJobs(String date, String period, String mode) throws ValidatorAdminException {
        int jobsDeleted = 0;
        try {
            logger.debug((Object)("Deleting jobs " + period + " than " + date));
            if (mode.equalsIgnoreCase("uncompleted_only")) {
                jobsDeleted = this.jobsDao.deleteUncompletedJobs();
            } else if (mode.equalsIgnoreCase("compTest_only")) {
                jobsDeleted = this.jobsDao.deleteOld(date, period, "Compatibility Test");
            } else if (mode.equalsIgnoreCase("all")) {
                jobsDeleted = this.jobsDao.deleteOld(date, period, null);
            } else if (mode.equalsIgnoreCase("import")) {
                this.jobsDao.importOldJobs();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error deleting old jobs", (Throwable)e);
            throw new ValidatorAdminException((Throwable)e);
        }
        return jobsDeleted;
    }

    public Emailer getEmailer() {
        return this.emailer;
    }

    public JobsDAO getJobsDao() {
        return this.jobsDao;
    }

    public void setJobsDao(JobsDAO jobsDao) {
        this.jobsDao = jobsDao;
    }

    public RulesetsDAO getRulesetsDao() {
        return this.rulesetsDao;
    }

    public void setRulesetsDao(RulesetsDAO rulesetsDao) {
        this.rulesetsDao = rulesetsDao;
    }

    public RulesDAO getRulesDao() {
        return this.rulesDao;
    }

    public void setRulesDao(RulesDAO rulesDao) {
        this.rulesDao = rulesDao;
    }

    public UsersDAO getUsersDao() {
        return this.usersDao;
    }

    public void setUsersDao(UsersDAO usersDao) {
        this.usersDao = usersDao;
    }

    public void setEmailer(Emailer emailer) {
        this.emailer = emailer;
    }

    public String getRegistrationsReportEmail() {
        return this.registrationsReportEmail;
    }

    public void setRegistrationsReportEmail(String registrationsReportEmail) {
        this.registrationsReportEmail = registrationsReportEmail;
    }

    public EmailBuilder getEmailBuilder() {
        return this.emailBuilder;
    }

    public void setEmailBuilder(EmailBuilder emailBuilder) {
        this.emailBuilder = emailBuilder;
    }

    public boolean userIsMasterAdmin(String user) throws ValidatorAdminException {
        logger.debug((Object)("checking if user " + user + " is master admin"));
        if (this.masterAdmins.contains(user)) {
            logger.debug((Object)"is master admin");
            return true;
        }
        logger.debug((Object)"isn't master admin");
        return false;
    }

    public boolean userIsSecondaryAdmin(String user) throws ValidatorAdminException {
        logger.debug((Object)("checking if user " + user + " is secondary admin"));
        if (this.secondaryAdmins.contains(user)) {
            logger.debug((Object)"is secondary admin");
            return true;
        }
        logger.debug((Object)"isn't secondary admin");
        return false;
    }

    public void setMasterAdmins(String masterAdmins) {
        String[] recps;
        for (String recp : recps = masterAdmins.split(",")) {
            recp = recp.trim();
            this.masterAdmins.add(recp);
        }
    }

    public void setSecondaryAdmins(String secondaryAdmins) {
        String[] recps;
        for (String recp : recps = secondaryAdmins.split(",")) {
            recp = recp.trim();
            this.secondaryAdmins.add(recp);
        }
    }

    public String sendRegistrationsReport(String dateFrom, String dateTo, String month, String year) throws ValidatorAdminException {
        try {
            List jobs = null;
            HashMap<String, String> jobInfo = null;
            ArrayList passedJobsList = new ArrayList();
            ArrayList failedJobsList = new ArrayList();
            HashMap<String, Object> passedJobsMap = new HashMap<String, Object>();
            HashMap<String, Object> failedJobsMap = new HashMap<String, Object>();
            logger.debug((Object)("Sending registrations Report for period: " + dateFrom + " to: " + dateTo));
            jobs = this.jobsDao.getJobs(null, "Registration Request", null, null, dateFrom, dateTo);
            for (Object job : jobs) {
                String key = job.getBaseUrl() + "|" + job.getDesiredCompatibilityLevel();
                if (job.getContentJobScore() >= 50 && job.getContentJobScore() >= 50) {
                    failedJobsMap.remove(key);
                    passedJobsMap.put(key, job);
                    continue;
                }
                if (passedJobsMap.containsKey(key)) continue;
                failedJobsMap.put(key, job);
            }
            boolean oldFormat = false;
            for (StoredJob job : passedJobsMap.values()) {
                jobInfo = new HashMap<String, String>();
                jobInfo.put("name", job.getOfficialName());
                jobInfo.put("baseUrl", job.getBaseUrl());
                jobInfo.put("email", job.getUserEmail());
                jobInfo.put("compliance", job.getDesiredCompatibilityLevel());
                if (job.getOfficialName() == null) {
                    oldFormat = true;
                }
                passedJobsList.add(jobInfo);
            }
            for (StoredJob job : failedJobsMap.values()) {
                jobInfo = new HashMap();
                jobInfo.put("name", job.getOfficialName());
                jobInfo.put("baseUrl", job.getBaseUrl());
                jobInfo.put("email", job.getUserEmail());
                jobInfo.put("compliance", job.getDesiredCompatibilityLevel());
                if (job.getOfficialName() == null) {
                    oldFormat = true;
                }
                failedJobsList.add(jobInfo);
            }
            String report = this.emailBuilder.buildXml(passedJobsList, failedJobsList, month, oldFormat);
            ArrayList<String> recps = new ArrayList<String>();
            recps.add(this.registrationsReportEmail);
            this.emailer.sendMail(recps, "Datasource Registrations -- " + month + " " + year, report, true, null);
            logger.debug((Object)("email : " + report));
            return report;
        }
        catch (Exception e) {
            logger.error((Object)"Error deleting old jobs", (Throwable)e);
            throw new ValidatorAdminException((Throwable)e);
        }
    }
}

