/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.actions.jobs;

import eu.dnetlib.validator.admin.actions.BaseValidatorAction;
import eu.dnetlib.validator.admin.api.ValidatorAdminException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class DatabaseCurator
extends BaseValidatorAction {
    private static final long serialVersionUID = -1868055729316139461L;
    private static final Logger logger = Logger.getLogger(DatabaseCurator.class);
    private String inDate = null;
    private String mode;
    private String period;

    public String execute() {
        this.clearErrorsAndMessages();
        int jobsDeleted = 0;
        try {
            jobsDeleted = this.getValidatorAdminAPI().deleteOldJobs(this.inDate, this.period, this.mode);
        }
        catch (ValidatorAdminException e) {
            logger.error((Object)"Error deleting old jobs", (Throwable)e);
            this.addActionError(this.getText("generic.error"));
            this.reportException((Exception)((Object)e));
            return "input-problem";
        }
        this.addActionMessage(jobsDeleted + " " + this.getText("manageJobs.deleteJobs.success"));
        return "success";
    }

    public void validate() {
        this.clearErrors();
        if (!this.mode.equalsIgnoreCase("uncompleted_only")) {
            if (this.inDate == null) {
                this.addActionError(this.getText("wrongFieldValue"));
                return;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (this.inDate.trim().length() != dateFormat.toPattern().length()) {
                this.addActionError(this.getText("wrongFieldValue"));
                return;
            }
            dateFormat.setLenient(false);
            try {
                dateFormat.parse(this.inDate.trim());
            }
            catch (ParseException pe) {
                this.addActionError(this.getText("wrongFieldValue"));
                return;
            }
        }
    }

    public String getInDate() {
        return this.inDate;
    }

    public void setInDate(String inDate) {
        this.inDate = inDate;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }
}

