/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.actions.rules;

import eu.dnetlib.domain.functionality.validator.Rule;
import eu.dnetlib.validator.admin.actions.BaseValidatorAction;
import eu.dnetlib.validator.admin.api.ValidatorAdminException;
import eu.dnetlib.validator.admin.constants.TypesAndTableNames;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PrepareAddRule
extends BaseValidatorAction {
    private static final long serialVersionUID = -8414397033694574297L;
    private Logger logger = Logger.getLogger(PrepareAddRule.class);
    private String type;
    private Boolean forCris;
    private Boolean forUsage = false;
    private List<String> labels;
    private String jobType;
    private Set<String> entityTypes;
    private List<Rule> rules;

    public String execute() {
        this.clearErrorsAndMessages();
        this.logger.debug((Object)("preparing to add rule of type " + this.type));
        this.logger.debug((Object)("cris:  " + this.forCris));
        this.entityTypes = TypesAndTableNames.getCrisEntities().keySet();
        if (this.jobType.equals("usage")) {
            this.forUsage = true;
        }
        try {
            this.labels = this.getValidatorAdminAPI().getRuleLabels(this.type, this.forUsage, this.forCris);
        }
        catch (ValidatorAdminException e) {
            return "error";
        }
        if (this.type.equals("ChainRule")) {
            try {
                this.rules = this.getValidatorAdminAPI().getAllRules();
            }
            catch (ValidatorAdminException e) {
                return "error";
            }
        }
        return "success";
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public String getType() {
        return this.type;
    }

    public String getJobType() {
        return this.jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public Set<String> getEntityTypes() {
        return this.entityTypes;
    }

    public void setEntityTypes(Set<String> entityTypes) {
        this.entityTypes = entityTypes;
    }

    public Boolean getForCris() {
        return this.forCris;
    }

    public void setForCris(Boolean forCris) {
        this.forCris = forCris;
    }
}

