/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.actions.rulesets;

import eu.dnetlib.domain.functionality.validator.Rule;
import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.validator.admin.actions.BaseValidatorAction;
import eu.dnetlib.validator.admin.constants.TypesAndTableNames;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class GetRules
extends BaseValidatorAction {
    private static final long serialVersionUID = 3336444896590055688L;
    private int setId = -1;
    private List<Rule> rulesContent;
    private List<Rule> rulesUsage;
    private Set<Integer> ruleIdsContent;
    private Set<Integer> ruleIdsUsage;
    private List<String> deployEnvironments;
    private String funct = null;
    private RuleSet ruleSet;
    private static final Logger logger = Logger.getLogger(GetRules.class);

    public String execute() {
        this.clearErrorsAndMessages();
        try {
            logger.debug((Object)("getting rules in rule set " + this.setId));
            this.ruleIdsContent = new HashSet();
            this.ruleIdsUsage = new HashSet();
            this.rulesContent = new ArrayList();
            this.rulesUsage = new ArrayList();
            this.splitRules(this.getValidatorAdminAPI().getAllRules(), this.rulesContent, this.rulesUsage);
            this.deployEnvironments = TypesAndTableNames.deployEnvironments;
            if (this.setId == -1) {
                this.ruleSet = new RuleSet();
                this.ruleSet.setId(Integer.valueOf(-1));
                this.funct = "create";
            } else {
                this.funct = "edit";
                this.ruleSet = this.getValidatorAdminAPI().getRuleSet(this.setId);
                this.ruleIdsContent = this.ruleSet.getContentRulesIds();
                this.ruleIdsUsage = this.ruleSet.getUsageRulesIds();
            }
            return "success";
        }
        catch (Exception e) {
            logger.error((Object)"Error getting rules", (Throwable)e);
            this.addActionError(this.getText("generic.error"));
            this.reportException(e);
            return "exception";
        }
    }

    private void splitRules(List<Rule> totalRules, List<Rule> contentRules, List<Rule> usageRules) {
        logger.debug((Object)"splitting rules..");
        for (Rule rule : totalRules) {
            if (rule.getJob_type().equals("content")) {
                contentRules.add(rule);
                continue;
            }
            if (!rule.getJob_type().equals("usage")) continue;
            usageRules.add(rule);
        }
    }

    public String getFunct() {
        return this.funct;
    }

    public void setFunct(String funct) {
        this.funct = funct;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    public int getSetId() {
        return this.setId;
    }

    public void setSetId(int setId) {
        this.setId = setId;
    }

    public List<Rule> getRulesContent() {
        return this.rulesContent;
    }

    public void setRulesContent(List<Rule> rulesContent) {
        this.rulesContent = rulesContent;
    }

    public List<Rule> getRulesUsage() {
        return this.rulesUsage;
    }

    public void setRulesUsage(List<Rule> rulesUsage) {
        this.rulesUsage = rulesUsage;
    }

    public Set<Integer> getRuleIdsContent() {
        return this.ruleIdsContent;
    }

    public void setRuleIdsContent(Set<Integer> ruleIdsContent) {
        this.ruleIdsContent = ruleIdsContent;
    }

    public Set<Integer> getRuleIdsUsage() {
        return this.ruleIdsUsage;
    }

    public void setRuleIdsUsage(Set<Integer> ruleIdsUsage) {
        this.ruleIdsUsage = ruleIdsUsage;
    }

    public List<String> getDeployEnvironments() {
        return this.deployEnvironments;
    }

    public void setDeployEnvironments(List<String> deployEnvironments) {
        this.deployEnvironments = deployEnvironments;
    }
}

