/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.api.impls;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class EmailBuilder {
    private static Logger logger = Logger.getLogger(EmailBuilder.class);
    private VelocityEngine ve = null;

    public void init() throws Exception {
        this.ve = new VelocityEngine();
        this.ve.setProperty("resource.loader", (Object)"classpath");
        this.ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        this.ve.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        this.ve.init();
    }

    public String buildXml(List<Map<String, String>> passedJobsList, List<Map<String, String>> failedJobsList, String month, boolean oldFormat) {
        logger.debug((Object)"Building the registrations report Email");
        String finalEmail = null;
        try {
            VelocityContext context = new VelocityContext();
            context.put("passedJobs", passedJobsList);
            context.put("failedJobs", failedJobsList);
            context.put("month", (Object)month);
            if (passedJobsList.isEmpty()) {
                context.put("nonePassed", (Object)"There are no successful registration attempts.");
            } else {
                context.put("nonePassed", (Object)" ");
            }
            if (failedJobsList.isEmpty()) {
                context.put("noneFailed", (Object)"There are no failed registration attempts.");
            } else {
                context.put("noneFailed", (Object)" ");
            }
            Template t = oldFormat ? this.ve.getTemplate("/eu/dnetlib/validator/admin/api/emailTeplateOld.vm") : this.ve.getTemplate("/eu/dnetlib/validator/admin/api/emailTeplate.vm");
            StringWriter writer = new StringWriter();
            t.merge((Context)context, (Writer)writer);
            finalEmail = writer.toString();
        }
        catch (TransformerConfigurationException e) {
            logger.error((Object)"Error while building XML file", (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            logger.error((Object)"Error while building XML file", (Throwable)e);
        }
        catch (TransformerException e) {
            logger.error((Object)"Error while building XML file", (Throwable)e);
        }
        catch (ResourceNotFoundException e) {
            logger.error((Object)"Error while building XML file", (Throwable)e);
        }
        catch (ParseErrorException e) {
            logger.error((Object)"Error while building XML file", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Error while building XML file", (Throwable)e);
        }
        return finalEmail;
    }
}

