/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.actions.login;

import eu.dnetlib.validator.admin.actions.BaseValidatorAction;
import eu.dnetlib.validator.admin.config.Constants;
import java.util.Calendar;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.SessionAware;

public class PortalLogin
extends BaseValidatorAction
implements ServletRequestAware,
SessionAware {
    private static final long serialVersionUID = -6312800103845446815L;
    private transient Logger logger = Logger.getLogger(PortalLogin.class);
    private HttpServletRequest request;
    private Map<String, Object> session;
    private String user;
    private String ip;
    private String valid;
    private String signature;
    private String key;
    private String email;

    public void validate() {
        this.clearErrors();
        this.logger.debug((Object)("validating log-in from portal link " + this.user + ", " + this.ip + ", " + this.valid + ", " + this.signature));
        if (this.user == null || this.ip == null || this.valid == null) {
            this.addActionError(this.getText("login.manual"));
            return;
        }
        if (this.user.trim().equals("") || this.ip.trim().equals("") || this.valid.trim().equals("")) {
            this.addActionError(this.getText("login.manual"));
            return;
        }
        long millisUntil = 0L;
        try {
            millisUntil = Long.parseLong(this.valid);
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            this.addActionError(this.getText("login.manual"));
            return;
        }
        try {
            if (!this.signatureIsValid((this.user + this.ip + this.valid).trim(), this.signature.trim())) {
                this.logger.debug((Object)"signature was not valid");
                this.addActionError(this.getText("login.manual"));
                return;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            this.addActionError(this.getText("login.manual"));
            return;
        }
        Calendar cal = Calendar.getInstance();
        if (cal.getTime().getTime() > millisUntil) {
            this.logger.debug((Object)("link has expired current-time: " + cal.getTime().getTime() + " link-time: " + millisUntil));
            this.addActionError(this.getText("login.manual"));
            return;
        }
        if (!this.ip.trim().equals(this.request.getRemoteAddr().trim())) {
            this.logger.debug((Object)("ips are different " + this.ip + " " + this.request.getRemoteAddr()));
            this.addActionError(this.getText("login.manual"));
            return;
        }
        try {
            this.email = this.getUserAPI().getEmailFromUsername(this.user);
            if (this.email == null) {
                this.email = "";
                this.addActionError(this.getText("login.userNotExists"));
                return;
            }
            if (!this.getUserAPI().userExists(this.getEmail())) {
                this.email = "";
                this.addActionError(this.getText("login.userNotExists"));
                return;
            }
            if (!this.getUserAPI().isUserActivated(this.getEmail())) {
                this.email = "";
                this.addActionError(this.getText("login.notActivated"));
                return;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            this.addActionError(e.toString());
        }
    }

    public String execute() {
        this.clearErrorsAndMessages();
        try {
            this.logger.debug((Object)("logging-in from portal link " + this.user + ", " + this.ip + ", " + this.valid + ", " + this.signature));
            this.session.put(Constants.loggedInField, this.getEmail());
            this.session.put("email", this.getEmail());
            if (this.getUserAPI().isAdmin(this.email)) {
                this.session.put("isAdmin", "true");
            }
            this.addActionMessage("Logged-in successfully");
            return "success";
        }
        catch (Exception e) {
            this.logger.error((Object)("error logging-in from portal link " + this.user + ", " + this.ip + ", " + this.valid + ", " + this.signature), (Throwable)e);
            this.addActionError(this.getText("generic.error"));
            this.reportException(e);
            return "exception";
        }
    }

    public boolean signatureIsValid(String message, String signature) throws Exception {
        byte[] encode = Hex.decodeHex((char[])new String(Base64.decodeBase64((byte[])signature.getBytes())).toCharArray());
        SecretKeySpec key = new SecretKeySpec(this.key.getBytes(), "HmacSHA1");
        Mac mac = Mac.getInstance(key.getAlgorithm());
        mac.init(key);
        byte[] myEncode = mac.doFinal(message.getBytes());
        this.logger.debug((Object)("given encode: " + new String(encode) + " my-encode: " + new String(myEncode)));
        if (encode.length != myEncode.length) {
            return false;
        }
        for (int i = 0; i < encode.length; ++i) {
            if (encode[i] == myEncode[i]) continue;
            return false;
        }
        return true;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getServletRequest() {
        return this.request;
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getValid() {
        return this.valid;
    }

    public void setValid(String valid) {
        this.valid = valid;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

