/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.api.impls;

import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.validator.admin.api.UserApi;
import eu.dnetlib.validator.commons.dao.users.UsersDAO;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRED)
public class UserApiLocal
implements UserApi {
    private static Logger logger = Logger.getLogger(UserApiLocal.class);
    private UsersDAO usersDao;

    @Transactional
    public boolean activateUser(String activationId) throws Exception {
        this.usersDao.activateUser(activationId);
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public String addUser(String username, String email, String password, String firstName, String lastName, String institution) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(password.getBytes());
        BigInteger hash = new BigInteger(1, md5.digest());
        String hashword = hash.toString(16);
        String activationId = UUID.randomUUID().toString();
        UserProfile newUser = new UserProfile();
        newUser.setEmail(email);
        newUser.setPassword(hashword);
        newUser.setFirstname(firstName);
        newUser.setLastname(lastName);
        newUser.setUsername(username);
        newUser.setInstitution(institution);
        newUser.setActivationId(activationId);
        this.usersDao.save((Object)newUser);
        return activationId;
    }

    public boolean correctCreds(String email, String password) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(password.getBytes());
        BigInteger hash = new BigInteger(1, md5.digest());
        String hashword = hash.toString(16);
        if (this.usersDao.checkCorrectCreds(email, hashword)) {
            logger.debug((Object)"Password verified");
            return true;
        }
        logger.debug((Object)("no user found with email: " + email + " and pass: " + password + " (" + hashword + ")"));
        return false;
    }

    public boolean isAdmin(String email) throws Exception {
        return this.usersDao.isAdmin(email);
    }

    public boolean isUserActivated(String email) throws Exception {
        return this.usersDao.isActivated(email);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public String prepareResetPassword(String email) throws Exception {
        String uuid = UUID.randomUUID().toString();
        this.usersDao.prepareResetPassword(uuid, email);
        return uuid;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void resetPassword(String uuid, String password) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(password.getBytes());
        BigInteger hash = new BigInteger(1, md5.digest());
        String hashword = hash.toString(16);
        this.usersDao.ResetPassword(uuid, hashword);
    }

    public boolean userExists(String email) throws Exception {
        return this.usersDao.userExists(email);
    }

    public void editUser(UserProfile user) throws Exception {
        this.usersDao.save((Object)user);
    }

    public boolean usernameExists(String username) throws Exception {
        return this.usersDao.usernameExists(username);
    }

    public String getEmailFromUsername(String username) throws Exception {
        UserProfile user = this.usersDao.get(username);
        if (user == null) {
            return null;
        }
        return this.usersDao.get(username).getEmail();
    }

    public UserProfile getUser(String userIdentifier) throws Exception {
        return this.usersDao.get(userIdentifier);
    }

    public UsersDAO getUsersDao() {
        return this.usersDao;
    }

    public void setUsersDao(UsersDAO usersDao) {
        this.usersDao = usersDao;
    }
}

