/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.actions.jobs;

import eu.dnetlib.validator.admin.actions.BaseValidatorAction;
import eu.dnetlib.validator.admin.api.ValidatorAdminException;
import org.apache.log4j.Logger;

public class RegistrationsReport
extends BaseValidatorAction {
    private static final long serialVersionUID = -1868055729316139461L;
    private static final Logger logger = Logger.getLogger(RegistrationsReport.class);
    private String dateFrom = null;
    private String dateTo = null;
    private String mode;
    private String month;
    private int year;

    public String execute() {
        this.clearErrorsAndMessages();
        try {
            int monthInt = Integer.parseInt(this.month.split("-")[1]);
            String monthStr = this.month.split("-")[0];
            this.dateFrom = new String("YYYY-MM-01").replaceFirst("MM", Integer.toString(monthInt)).replaceFirst("YYYY", Integer.toString(this.year));
            this.dateTo = monthInt != 12 ? new String("YYYY-MM-01").replaceFirst("MM", Integer.toString(monthInt + 1)).replaceFirst("YYYY", Integer.toString(this.year)) : new String("YYYY-MM-01").replaceFirst("MM", "1").replaceFirst("YYYY", Integer.toString(this.year + 1));
            this.getValidatorAdminAPI().sendRegistrationsReport(this.dateFrom, this.dateTo, monthStr, Integer.toString(this.year));
        }
        catch (ValidatorAdminException e) {
            logger.error((Object)"Error deleting old jobs", (Throwable)e);
            this.addActionError(this.getText("generic.error"));
            this.reportException((Exception)((Object)e));
            return "input-problem";
        }
        this.addActionMessage(this.getText("manageJobs.sendReports.success"));
        return "success";
    }

    public void validate() {
        this.clearErrors();
    }

    public String getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
    }

    public String getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(String dateTo) {
        this.dateTo = dateTo;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMonth() {
        return this.month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }
}

