/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.actions.rules;

import eu.dnetlib.domain.functionality.validator.Rule;
import eu.dnetlib.validator.admin.actions.BaseValidatorAction;
import org.apache.log4j.Logger;

public class AddRule
extends BaseValidatorAction {
    private static final long serialVersionUID = -4636737264204104816L;
    private String[] inputs;
    private String type;
    private String jobType;
    private boolean forCris;
    private static final Logger logger = Logger.getLogger(AddRule.class);

    public String execute() {
        this.clearErrorsAndMessages();
        try {
            logger.debug((Object)("adding rule of type " + this.type + " using user inputs"));
            logger.debug((Object)("for cris: " + this.forCris));
            logger.debug((Object)("jobType: " + this.jobType));
            Rule rule = new Rule();
            rule.setType(this.type);
            rule.setJob_type(this.jobType);
            rule.setFor_cris(this.forCris);
            String ret = this.getValidatorAdminAPI().storeRule(rule, this.inputs, Boolean.valueOf(true));
            if (ret != null) {
                this.addActionError(this.getText(ret));
                return "input-problem";
            }
            this.addActionMessage(this.getText("addRule.success"));
            return "success";
        }
        catch (Exception e) {
            logger.error((Object)"Error adding rule", (Throwable)e);
            this.addActionError(this.getText("generic.error"));
            this.reportException(e);
            return "exception";
        }
    }

    public String getJobType() {
        return this.jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public boolean isForCris() {
        return this.forCris;
    }

    public void setForCris(boolean forCris) {
        this.forCris = forCris;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String[] getInputs() {
        return this.inputs;
    }

    public void setInputs(String[] inputs) {
        this.inputs = inputs;
    }
}

