/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.constants;

import eu.dnetlib.validator.admin.constants.TypesAndTableNames;
import eu.dnetlib.validator.admin.constants.fielddetails.FieldDetails;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FieldsAndDetails {
    private static Map<String, List<FieldDetails>> map;
    private static Logger logger;

    public static List<FieldDetails> getFieldsAndDetails(String tablename) {
        logger.debug((Object)("getting fielddetails of table " + tablename));
        if (tablename != null) {
            List ret = (List)map.get(tablename = tablename.toLowerCase());
            if (ret == null) {
                ret = (List)map.get(TypesAndTableNames.getTableNameOfType((String)tablename));
            }
            return ret;
        }
        return null;
    }

    static {
        logger = Logger.getLogger(FieldsAndDetails.class);
        logger.debug((Object)"initializing map of FieldsAndDetails");
        map = new HashMap();
        BufferedReader br = new BufferedReader(new InputStreamReader(FieldsAndDetails.class.getResourceAsStream("/eu/dnetlib/validator/admin/constants/fieldDetails.txt")));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                ArrayList<FieldDetails> lfd = new ArrayList<FieldDetails>();
                String tableName = line.trim();
                while ((line = br.readLine()) != null && !line.trim().equals("")) {
                    String[] args = line.split(" ");
                    FieldDetails details = new FieldDetails();
                    details.setTableName(tableName);
                    details.setFieldName(args[0].trim());
                    details.setForDet(Boolean.parseBoolean(args[1].trim().toLowerCase()));
                    lfd.add(details);
                }
                map.put(tableName.toLowerCase(), lfd);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error initialiazing map of FieldsAndDetails", (Throwable)e);
        }
    }
}

