/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.actions.login;

import eu.dnetlib.validator.admin.actions.BaseValidatorAction;
import org.apache.log4j.Logger;

public class ResetPassword
extends BaseValidatorAction {
    private static final long serialVersionUID = -4565098546731325693L;
    private Logger logger = Logger.getLogger(ResetPassword.class);
    private String password;
    private String repassword;
    private String securityCode;

    public String execute() {
        this.clearErrorsAndMessages();
        try {
            this.logger.debug((Object)("reseting password with security code " + this.securityCode));
            this.getUserAPI().resetPassword(this.getSecurityCode(), this.getPassword());
            this.addActionMessage(this.getText("resetPassword.success"));
            return "success";
        }
        catch (Exception e) {
            this.logger.error((Object)("error reseting password with security code " + this.securityCode), (Throwable)e);
            this.addActionError(this.getText("generic.error"));
            return "exception";
        }
    }

    public void validate() {
        this.clearErrors();
        try {
            if (this.getSecurityCode() == null || this.getSecurityCode().length() == 0) {
                this.addFieldError("securityCode", this.getText("resetPassword.wrongSecurityCode"));
                return;
            }
            if (!this.getPassword().equals(this.getRepassword())) {
                this.addFieldError("password", this.getText("identicalPasswords"));
                return;
            }
        }
        catch (Exception e) {
            this.addActionError("");
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRepassword() {
        return this.repassword;
    }

    public void setRepassword(String repassword) {
        this.repassword = repassword;
    }

    public String getSecurityCode() {
        return this.securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }
}

