/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.admin.actions.rulesets;

import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.validator.admin.actions.BaseValidatorAction;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreateRuleSet
extends BaseValidatorAction {
    private static final long serialVersionUID = 5623461974078831740L;
    private Set<Integer> chosenContentRules = null;
    private Set<Integer> chosenUsageRules = null;
    private String funct = null;
    private RuleSet ruleSet;
    private static final Logger logger = Logger.getLogger(CreateRuleSet.class);

    public String execute() {
        this.clearErrorsAndMessages();
        try {
            logger.debug((Object)("creating a new rule set " + this.ruleSet.getName()));
            this.ruleSet.setUsageRulesIds(this.chosenUsageRules);
            this.ruleSet.setContentRulesIds(this.chosenContentRules);
            if (this.funct.equals("create")) {
                this.getValidatorAdminAPI().storeRuleSet(this.ruleSet, false);
                this.addActionMessage(this.getText("createRuleSet.success"));
            } else if (this.funct.equals("edit")) {
                logger.debug((Object)("chosen content: " + this.chosenContentRules));
                this.getValidatorAdminAPI().storeRuleSet(this.ruleSet, true);
                this.addActionMessage(this.getText("createRuleSet.success"));
            }
            return "success";
        }
        catch (Exception e) {
            logger.error((Object)"Error creating/editing ruleset", (Throwable)e);
            this.addActionError(this.getText("generic.error"));
            this.reportException(e);
            return "exception";
        }
    }

    public void validate() {
        this.clearErrors();
        if (this.chosenContentRules == null || this.chosenContentRules.isEmpty() || this.chosenUsageRules == null || this.chosenUsageRules.isEmpty()) {
            this.addActionError(this.getText("createRuleSets.atLeastOneRule"));
        }
        if (this.funct == null) {
            this.addActionError(this.getText("uknownError"));
        }
    }

    public String getFunct() {
        return this.funct;
    }

    public void setFunct(String funct) {
        this.funct = funct;
    }

    public Set<Integer> getChosenContentRules() {
        return this.chosenContentRules;
    }

    public void setChosenContentRules(Set<Integer> chosenContentRules) {
        this.chosenContentRules = chosenContentRules;
    }

    public Set<Integer> getChosenUsageRules() {
        return this.chosenUsageRules;
    }

    public void setChosenUsageRules(Set<Integer> chosenUsageRules) {
        this.chosenUsageRules = chosenUsageRules;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }
}

