/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.commons.dao;

import eu.dnetlib.validator.commons.dao.DAO;
import eu.dnetlib.validator.commons.dao.DaoException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.datasource.DataSourceUtils;

public abstract class AbstractDAO<T>
implements DAO<T> {
    protected DataSource datasource = null;
    protected static Logger logger = Logger.getLogger(AbstractDAO.class);

    protected abstract PreparedStatement getUpdateStatement(T var1, Connection var2) throws SQLException;

    protected abstract PreparedStatement getInsertStatement(T var1, Connection var2) throws SQLException;

    protected abstract PreparedStatement getDeleteStatement(int var1, Connection var2) throws SQLException;

    protected abstract int getLastId() throws SQLException, DaoException;

    @Override
    public Integer save(T t) throws DaoException {
        Connection con = null;
        Statement stmt = null;
        Integer retId = -1;
        logger.debug((Object)"Accessing DB to save/update ");
        try {
            con = this.getConnection();
            stmt = this.getUpdateStatement(t, con);
            if (stmt.executeUpdate() == 0) {
                stmt.close();
                stmt = this.getInsertStatement(t, con);
                stmt.executeUpdate();
                retId = this.getLastId();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Error while accessing DB to save/update: ", (Throwable)e);
            throw new DaoException(e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"Error while accessing DB to save/update: ", (Throwable)e);
                    throw new DaoException(e);
                }
            }
        }
        return retId;
    }

    @Override
    public String delete(int id) throws DaoException {
        Connection con = null;
        Statement stmt = null;
        logger.debug((Object)"Accessing DB to delete ");
        try {
            con = this.getConnection();
            stmt = this.getDeleteStatement(id, con);
            if (stmt.executeUpdate() == 0) {
                stmt.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while accessing DB to delete: ", (Throwable)e);
            throw new DaoException(e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Error while accessing DB to delete: ", (Throwable)e);
                    throw new DaoException(e);
                }
            }
        }
        return null;
    }

    protected Connection getConnection() throws DaoException {
        try {
            Connection conn = DataSourceUtils.getConnection((DataSource)this.datasource);
            return conn;
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    protected void closeConnection(Connection con) {
        if (con != null) {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.datasource);
        }
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }
}

