/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.commons.email;

import eu.dnetlib.utils.MailLibrary;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class Emailer {
    private static Logger logger = Logger.getLogger(Emailer.class);
    private List<String> specialRecipients = new ArrayList<String>();
    private boolean override = false;
    private boolean logonly = false;
    private String overrideEmail = null;
    private String from = null;
    private MailLibrary mailer = null;

    public void sendMail(List<String> recipients, String subject, String message, boolean sendToSpecial, List<String> repoAdminMails) throws Exception {
        try {
            if (sendToSpecial) {
                recipients.addAll(this.specialRecipients);
            }
            if (repoAdminMails != null) {
                recipients.addAll(repoAdminMails);
            }
            if (this.override) {
                recipients.clear();
                recipients.add(this.overrideEmail);
            }
            logger.debug((Object)("Sending mail to Recipients: " + recipients + " Subject: " + subject + " Message: " + message));
            if (!this.logonly) {
                this.mailer.sendEmail(recipients.toArray(new String[0]), subject, message);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error sending mail to Recipients: " + recipients + " Subject: " + subject + " Message: " + message), (Throwable)e);
            throw new Exception(e);
        }
    }

    public void setSpecialRecipients(String specialRecipients) {
        String[] recps;
        for (String recp : recps = specialRecipients.split(",")) {
            recp = recp.trim();
            this.specialRecipients.add(recp);
        }
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public void setOverrideEmail(String overrideEmail) {
        this.overrideEmail = overrideEmail;
    }

    public void setMailer(MailLibrary mailer) {
        this.mailer = mailer;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public boolean isLogonly() {
        return this.logonly;
    }

    public void setLogonly(boolean logonly) {
        this.logonly = logonly;
    }
}

