/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline;

import eu.dnetlib.validator2.engine.Helper;
import eu.dnetlib.validator2.engine.Reporter;
import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.engine.RuleDiagnostics;
import eu.dnetlib.validator2.engine.RuleEngine;
import eu.dnetlib.validator2.engine.Status;
import eu.dnetlib.validator2.engine.builtins.StandardRuleDiagnostics;
import eu.dnetlib.validator2.validation.guideline.CompilationResult;
import eu.dnetlib.validator2.validation.guideline.RequirementLevel;
import eu.dnetlib.validator2.validation.guideline.StandardResult;
import eu.dnetlib.validator2.validation.guideline.SyntheticRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

class GuidelineEvaluation {
    private static final Logger logger = LoggerFactory.getLogger(GuidelineEvaluation.class);
    private static final RuleDiagnostics<Document, Rule<Document>> OUT = Helper.Diagnostics.systemOut();
    private static final RuleDiagnostics<Document, Rule<Document>> ERR = Helper.Diagnostics.systemErr();
    private final String subjectId;
    private final Document doc;
    private final int weight;
    private final List<String> warnings = new ArrayList<String>();
    private final List<String> errors = new ArrayList<String>();
    private Map<String, RequirementLevel> ruleIdToRequirementLevel = new HashMap<String, RequirementLevel>();
    private Map<String, NodeList> ruleIdToNodeList = new HashMap<String, NodeList>();
    private final Diagnostics diagnostics = new Diagnostics();
    private final Reporter<Document, SyntheticRule<Document>> reporter = new Reporter<Document, SyntheticRule<Document>>(this.diagnostics);

    GuidelineEvaluation(String subjectId, Document doc, int weight) {
        this.subjectId = subjectId;
        this.doc = doc;
        this.weight = weight;
    }

    StandardResult evaluate(CompilationResult result) {
        this.ruleIdToRequirementLevel.putAll(result.ruleIdToRequirementLevel);
        ArrayList<SyntheticRule<Document>> rules = new ArrayList<SyntheticRule<Document>>();
        rules.add(result.rootNodeRule);
        rules.addAll(result.nodeRules);
        logger.debug("Evaluating " + rules);
        for (SyntheticRule syntheticRule : rules) {
            RuleEngine.applyAndReport(syntheticRule, this.doc, this.reporter);
            Status status = this.diagnostics.getLastReportedStatus();
            if (status == Status.ERROR) {
                return StandardResult.forError(this.diagnostics.getLastReportedError().getMessage());
            }
            String id = syntheticRule.getContext().getIdProperty().getValue();
            RequirementLevel requirementLevel = this.getRequirementLevelOf(id);
            if (status == Status.SUCCESS && requirementLevel == RequirementLevel.NOT_APPLICABLE) {
                logger.warn("Non-applicable: " + syntheticRule);
                this.warnings.add(this.synthesizeFailureMessage(syntheticRule));
                continue;
            }
            if (status != Status.FAILURE) continue;
            if (requirementLevel == RequirementLevel.MANDATORY || requirementLevel == RequirementLevel.MANDATORY_IF_APPLICABLE) {
                if (syntheticRule.parentRule() == null) {
                    logger.error("Fail fast for root failure: " + syntheticRule);
                    this.errors.add(this.synthesizeFailureMessage(syntheticRule));
                    return StandardResult.forFailure(this.warnings, this.errors);
                }
                if (this.getRequirementLevelOf(syntheticRule.parentRule().getContext().getIdProperty().getValue()) == RequirementLevel.MANDATORY || this.getRequirementLevelOf(syntheticRule.parentRule().getContext().getIdProperty().getValue()) == RequirementLevel.MANDATORY_IF_APPLICABLE) {
                    logger.error("Fail fast for root failure: " + syntheticRule);
                    this.errors.add(this.synthesizeFailureMessage(syntheticRule));
                    return StandardResult.forFailure(this.warnings, this.errors);
                }
                if (requirementLevel == RequirementLevel.MANDATORY) {
                    logger.warn("Mandatory failure: " + syntheticRule);
                } else {
                    logger.warn("Mandatory_If_Applicable failure: " + syntheticRule);
                }
                this.warnings.add(this.synthesizeFailureMessage(syntheticRule));
                continue;
            }
            if (requirementLevel == RequirementLevel.RECOMMENDED) {
                logger.warn("Recommended failure: " + syntheticRule);
            } else if (requirementLevel == RequirementLevel.OPTIONAL) {
                logger.warn("Optional failure: " + syntheticRule);
            } else {
                logger.error("UNKNOWN failure: " + syntheticRule);
            }
            this.warnings.add(this.synthesizeFailureMessage(syntheticRule));
        }
        int returnedWeight = this.weight;
        if (rules.size() == this.warnings.size()) {
            returnedWeight = 0;
        }
        return StandardResult.forSuccess(returnedWeight, this.warnings);
    }

    private String synthesizeFailureMessage(Rule<Document> rule) {
        return this.subjectId + ": rule " + Helper.stringify(rule) + " has failed";
    }

    private String synthesizeNotApplicableMessage(Rule<Document> rule) {
        return this.subjectId + ": rule " + Helper.stringify(rule) + " is not applicable";
    }

    void setNodesOf(String ruleId, NodeList nodes) {
        this.ruleIdToNodeList.put(ruleId, nodes);
    }

    NodeList getNodesOf(String ruleId) {
        return this.ruleIdToNodeList.get(ruleId);
    }

    void setRequirementLevelOf(String ruleId, RequirementLevel requirementLevel) {
        this.ruleIdToRequirementLevel.put(ruleId, requirementLevel);
    }

    RequirementLevel getRequirementLevelOf(String ruleId) {
        return this.ruleIdToRequirementLevel.get(ruleId);
    }

    public String toString() {
        return "GuidelineEvaluation{subjectId='" + this.subjectId + '\'' + ", doc=" + this.doc + ", weight=" + this.weight + ", warnings=" + this.warnings + ", errors=" + this.errors + ", ruleIdToRequirementLevel=" + this.ruleIdToRequirementLevel + ", ruleIdToNodeList=" + this.ruleIdToNodeList + ", diagnostics=" + this.diagnostics + ", reporter=" + this.reporter + '}';
    }

    private static final class Diagnostics
    extends StandardRuleDiagnostics<Document, SyntheticRule<Document>> {
        private final Map<String, Status> statusByRuleId = new HashMap<String, Status>();

        private Diagnostics() {
        }

        @Override
        public void success(SyntheticRule<Document> rule, Document document) {
            OUT.success(rule, document);
            super.success(rule, document);
            this.statusByRuleId.put(rule.getContext().getIdProperty().getValue(), Status.SUCCESS);
        }

        @Override
        public void failure(SyntheticRule<Document> rule, Document document) {
            OUT.failure(rule, document);
            super.failure(rule, document);
            this.statusByRuleId.put(rule.getContext().getIdProperty().getValue(), Status.FAILURE);
        }

        @Override
        public void error(SyntheticRule<Document> rule, Document document, Throwable err) {
            ERR.error(rule, document, err);
            super.error(rule, document, err);
            this.statusByRuleId.put(rule.getContext().getIdProperty().getValue(), Status.ERROR);
        }

        private Status statusFor(String ruleId) {
            return this.statusByRuleId.get(ruleId);
        }

        public String toString() {
            return "Diagnostics{statusByRuleId=" + this.statusByRuleId + '}';
        }
    }
}

