/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.engine.builtins.XMLCardinalityRule;
import eu.dnetlib.validator2.validation.guideline.AbstractGuideline;
import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.ElementPosition;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.RequirementLevel;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validator2.validation.utils.ISO639ValuePredicate;
import eu.dnetlib.validator2.validation.utils.RegexValuePredicate;
import eu.dnetlib.validator2.validation.utils.SupportedRegExs;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public class DataArchiveGuidelinesV2Profile
extends AbstractOpenAireProfile {
    private static final String[] identifierTypes = new String[]{"ARK", "DOI", "Handle", "PURL", "URN", "URL"};
    private static final String[] titleTypes = new String[]{"AlternativeTitle", "Subtitle", "TranslatedTitle"};
    private static final String[] contributorTypes = new String[]{"ContactPerson", "DataCollector", "DataCurator", "DataManager", "Distributor", "Editor", "Funder", "HostingInstitution", "Producer", "ProjectLeader", "ProjectManager", "ProjectMember", "RegistrationAgency", "RegistrationAuthority", "RelatedPerson", "Researcher", "ResearchGroup", "RightsHolder", "Sponsor", "Supervisor", "WorkPackageLeader", "Other"};
    private static final String[] dateTypes = new String[]{"Accepted", "Available", "Copyrighted", "Collected", "Created", "Issued", "Submitted", "Updated", "Valid"};
    private static final String[] resourceTypeGeneralValues = new String[]{"Audiovisual", "Collection", "Dataset", "Event", "Image", "InteractiveResource", "Model", "PhysicalObject", "Service", "Software", "Sound", "Text", "Workflow", "Other"};
    private static final String[] relatedIdentifierTypes = new String[]{"ARK", "arXiv", "bibcode", "DOI", "EAN13", "EISSN", "Handle", "IGSN", "ISBN", "ISSN", "ISTC", "LISSN", "LSID", "PISSN", "PMID", "PURL", "UPC", "URL", "URN", "WOS"};
    private static final String[] relationTypes = new String[]{"IsCitedBy", "Cites", "IsSupplementTo", "IsSupplementedBy", "IsContinuedBy", "Continues", "HasMetadata", "IsMetadataFor", "IsNewVersionOf", "IsPreviousVersionOf", "IsPartOf", "HasPart", "IsReferencedBy", "References", "IsDocumentedBy", "Documents", "IsCompiledBy", "Compiles", "IsVariantFormOf", "IsOriginalFormOf", "IsIdenticalTo", "IsReviewedBy", "Reviews", "IsDerivedFrom", "IsSourceOf"};
    private static final String[] rightsURIList = new String[]{"info:eu-repo/semantics/closedAccess", "info:eu-repo/semantics/embargoedAccess", "info:eu-repo/semantics/restrictedAccess", "info:eu-repo/semantics/openAccess"};
    private static final String[] descriptionTypes = new String[]{"Abstract", "Methods", "SeriesInformation", "TableOfContents", "Other"};
    private static final ElementSpec IDENTIFIER_SPEC = Builders.forMandatoryElement("identifier", Cardinality.ONE).inContext("metadata", "oai_datacite", "payload", "resource").withMandatoryAttribute("identifierType", identifierTypes).build();
    private static final ElementSpec CREATOR_SPEC = Builders.forMandatoryElement("creator", Cardinality.ONE_TO_N).withSubElement(Builders.forMandatoryElement("creatorName", Cardinality.ONE)).withSubElement(Builders.forRecommendedElement("nameIdentifier").withRecommendedAttribute("nameIdentifierScheme").withRecommendedAttribute("schemeURI")).withSubElement(Builders.forRecommendedRepeatableElement("affiliation")).build();
    private static final ElementSpec TITLE_SPEC = Builders.forMandatoryElement("title", Cardinality.ONE_TO_N).withOptionalAttribute("titleType", titleTypes).build();
    private static final ElementSpec PUBLISHER_SPEC = Builders.forMandatoryElement("publisher", Cardinality.ONE).build();
    private static final ElementSpec PUBLICATION_YEAR_SPEC = Builders.forMandatoryElement("publicationYear", Cardinality.ONE).allowedValues(new RegexValuePredicate(SupportedRegExs.COMPILED_YEAR_YYYY_REG_EX)).build();
    private static final ElementSpec SUBJECT_SPEC = Builders.forRecommendedRepeatableElement("subject").withOptionalAttribute("subjectScheme").withOptionalAttribute("schemeURI").build();
    private static final ElementSpec CONTRIBUTOR_SPEC = Builders.forMandatoryIfApplicableElement("contributor", Cardinality.ONE_TO_N, AbstractOpenAireProfile.elementIsPresent("contributor")).withMandatoryIfApplicableAttribute("contributorType", DataArchiveGuidelinesV2Profile.appRuleForContributorType(), contributorTypes).withSubElement(Builders.forMandatoryIfApplicableElement("contributorName", Cardinality.ONE, AbstractOpenAireProfile.elementIsPresent("contributor"))).withSubElement(Builders.forMandatoryIfApplicableElement("nameIdentifier", Cardinality.ONE, DataArchiveGuidelinesV2Profile.appRuleForContributorNameIdentifier()).withMandatoryIfApplicableAttribute("nameIdentifierScheme", DataArchiveGuidelinesV2Profile.appRuleForContributorNameIdentifier()).withOptionalAttribute("schemeURI ")).withSubElement(Builders.forOptionalRepeatableElement("affiliation")).build();
    private static final ElementSpec DATE_SPEC = Builders.forMandatoryElement("date", Cardinality.ONE_TO_N).allowedValues(new RegexValuePredicate(SupportedRegExs.COMPILED_ISO_8601_DATE_REG_EX)).withMandatoryAttribute("dateType", dateTypes).build();
    private static final ElementSpec LANGUAGE_SPEC = Builders.forRecommendedRepeatableElement("language").allowedValues(new ISO639ValuePredicate()).build();
    private static final ElementSpec RESOURCE_TYPE_SPEC = Builders.forRecommendedElement("resourceType").withRecommendedAttribute("resourceTypeGeneral", resourceTypeGeneralValues).build();
    private static final ElementSpec ALTERNATE_IDENTIFIER_SPEC = Builders.forOptionalRepeatableElement("alternateIdentifier").withOptionalAttribute("alternateIdentifierType").build();
    private static final ElementSpec RELATED_IDENTIFIER_SPEC = Builders.forMandatoryIfApplicableElement("relatedIdentifier", Cardinality.ONE_TO_N, DataArchiveGuidelinesV2Profile.appRuleForRelatedIdentifier()).withMandatoryAttribute("relatedIdentifierType", relatedIdentifierTypes).withMandatoryAttribute("relationType", relationTypes).withOptionalAttribute("relatedMetadataScheme").withOptionalAttribute("schemeURI").withOptionalAttribute("schemeType").build();
    private static final ElementSpec SIZE_SPEC = Builders.forOptionalRepeatableElement("size").build();
    private static final ElementSpec FORMAT_SPEC = Builders.forOptionalRepeatableElement("format").build();
    private static final ElementSpec VERSION_SPEC = Builders.forOptionalRepeatableElement("version").build();
    private static final ElementSpec RIGHTS_SPEC = Builders.forMandatoryIfApplicableElement("rights", Cardinality.ONE_TO_N, AbstractOpenAireProfile.elementIsPresent("rights")).atPosition(ElementPosition.FIRST).withMandatoryAttribute("rightsURI", rightsURIList).build();
    private static final ElementSpec DESCRIPTION_SPEC = Builders.forMandatoryIfApplicableElement("description", Cardinality.ONE_TO_N, AbstractOpenAireProfile.elementIsPresent("rights")).withMandatoryAttribute("descriptionType", descriptionTypes).build();
    private static final ElementSpec GEOLOCATION_SPEC = Builders.forOptionalRepeatableElement("geoLocation").withSubElement(Builders.forOptionalElement("geoLocationPoint")).withSubElement(Builders.forOptionalElement("geoLocationBox")).withSubElement(Builders.forOptionalElement("geoLocationPlace")).build();
    public static final SyntheticGuideline IDENTIFIER = SyntheticGuideline.of("Identifier", "description", "https://guidelines.openaire.eu/en/latest/literature/field_identifier.html", "F", 4, RequirementLevel.MANDATORY, IDENTIFIER_SPEC);
    public static final SyntheticGuideline CREATOR = SyntheticGuideline.of("Creator", "description", "https://guidelines.openaire.eu/en/latest/data/field_creator.html", "F", 4, RequirementLevel.MANDATORY, CREATOR_SPEC);
    public static final SyntheticGuideline TITLE = SyntheticGuideline.of("Title", "description", "https://guidelines.openaire.eu/en/latest/data/field_title.html", "F", 4, RequirementLevel.MANDATORY, TITLE_SPEC);
    public static final SyntheticGuideline PUBLISHER = SyntheticGuideline.of("Publisher", "description", "https://guidelines.openaire.eu/en/latest/data/field_publisher.html", "F", 4, RequirementLevel.MANDATORY, PUBLISHER_SPEC);
    public static final SyntheticGuideline PUBLICATION_YEAR = SyntheticGuideline.of("Publication Year", "description", "https://guidelines.openaire.eu/en/latest/data/field_publicationyear.html", "F", 4, RequirementLevel.MANDATORY, PUBLICATION_YEAR_SPEC);
    public static final SyntheticGuideline SUBJECT = SyntheticGuideline.of("Subject", "description", "https://guidelines.openaire.eu/en/latest/data/field_subject.html", "F", 4, RequirementLevel.RECOMMENDED, SUBJECT_SPEC);
    public static final SyntheticGuideline CONTRIBUTOR = SyntheticGuideline.of("Contributor", "description", "https://guidelines.openaire.eu/en/latest/data/field_contributor.html", "F", 4, RequirementLevel.MANDATORY_IF_APPLICABLE, CONTRIBUTOR_SPEC);
    public static final SyntheticGuideline DATE = SyntheticGuideline.of("Date", "description", "https://guidelines.openaire.eu/en/latest/data/field_date.html", "F", 4, RequirementLevel.MANDATORY, DATE_SPEC);
    public static final SyntheticGuideline LANGUAGE = SyntheticGuideline.of("Language", "description", "https://guidelines.openaire.eu/en/latest/data/field_language.html", "F", 4, RequirementLevel.RECOMMENDED, LANGUAGE_SPEC);
    public static final SyntheticGuideline RESOURCE_TYPE = SyntheticGuideline.of("Resource Type", "description", "https://guidelines.openaire.eu/en/latest/data/field_resourcetype.html", "F", 4, RequirementLevel.RECOMMENDED, RESOURCE_TYPE_SPEC);
    public static final SyntheticGuideline ALTERNATE_IDENTIFIER = SyntheticGuideline.of("Alternate Identifier", "description", "https://guidelines.openaire.eu/en/latest/data/field_alternateidentifier.html", "F", 4, RequirementLevel.OPTIONAL, ALTERNATE_IDENTIFIER_SPEC);
    public static final SyntheticGuideline RELATED_IDENTIFIER = SyntheticGuideline.of("Related Identifier", "description", "https://guidelines.openaire.eu/en/latest/data/field_relatedidentifier.html", "F", 4, RequirementLevel.MANDATORY_IF_APPLICABLE, RELATED_IDENTIFIER_SPEC);
    public static final SyntheticGuideline SIZE = SyntheticGuideline.of("Size", "description", "https://guidelines.openaire.eu/en/latest/data/field_size.html", "F", 4, RequirementLevel.OPTIONAL, SIZE_SPEC);
    public static final SyntheticGuideline FORMAT = SyntheticGuideline.of("Format", "description", "https://guidelines.openaire.eu/en/latest/data/field_format.html", "F", 4, RequirementLevel.OPTIONAL, FORMAT_SPEC);
    public static final SyntheticGuideline VERSION = SyntheticGuideline.of("Version", "description", "https://guidelines.openaire.eu/en/latest/data/field_version.html", "F", 4, RequirementLevel.OPTIONAL, VERSION_SPEC);
    public static final SyntheticGuideline RIGHTS = SyntheticGuideline.of("Rights", "description", "https://guidelines.openaire.eu/en/latest/data/field_rights.html", "F", 4, RequirementLevel.MANDATORY_IF_APPLICABLE, RIGHTS_SPEC);
    public static final SyntheticGuideline DESCRIPTION = SyntheticGuideline.of("Description", "description", "https://guidelines.openaire.eu/en/latest/data/field_description.html", "F", 4, RequirementLevel.MANDATORY_IF_APPLICABLE, DESCRIPTION_SPEC);
    public static final SyntheticGuideline GEOLOCATION = SyntheticGuideline.of("Geolocation", "description", "https://guidelines.openaire.eu/en/latest/data/field_geolocation.html", "F", 4, RequirementLevel.OPTIONAL, GEOLOCATION_SPEC);
    private static final List<SyntheticGuideline> GUIDELINES = Collections.unmodifiableList(Arrays.asList(IDENTIFIER, CREATOR, TITLE, PUBLISHER, PUBLICATION_YEAR, SUBJECT, CONTRIBUTOR, DATE, LANGUAGE, RESOURCE_TYPE, ALTERNATE_IDENTIFIER, RELATED_IDENTIFIER, SIZE, FORMAT, VERSION, RIGHTS, DESCRIPTION, GEOLOCATION));
    private static final Map<String, SyntheticGuideline> GUIDELINE_MAP = GUIDELINES.stream().collect(Collectors.toMap(AbstractGuideline::getName, guideline -> guideline));
    private static final int MAX_SCORE = GUIDELINES.stream().map(AbstractGuideline::getWeight).reduce(0, Integer::sum);

    private static Rule<Document> appRuleForContributorType() {
        return XMLCardinalityRule.builder().setId("ApplicabilityRule").setXPathExpression("//*[name()='contributor']/@contributorType").setIsInclusive(true).setRange(1L, 1L).build();
    }

    private static Rule<Document> appRuleForContributorNameIdentifier() {
        return XMLCardinalityRule.builder().setId("ApplicabilityRule").setXPathExpression("//*[name()='contributor' and @contributorType='Funder']").setIsInclusive(true).setRange(1L, 1L).build();
    }

    private static Rule<Document> appRuleForRelatedIdentifier() {
        return XMLCardinalityRule.builder().setId("ApplicabilityRule").setXPathExpression("//*[name()='relatedIdentifier']").setIsInclusive(true).setRange(1L, 0x7FFFFFFFFFFFFFFEL).build();
    }

    public DataArchiveGuidelinesV2Profile() {
        super("OpenAIRE Guidelines for Data Archives Profile v2");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    public SyntheticGuideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}

