/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.StandardValidationResult;
import eu.dnetlib.validator2.validation.guideline.AbstractGuideline;
import eu.dnetlib.validator2.validation.guideline.RequirementLevel;
import eu.dnetlib.validator2.validation.guideline.StandardResult;
import eu.dnetlib.validator2.validation.guideline.openaire.R1_01M_LIT;
import eu.dnetlib.validator2.validation.utils.ResultUtils;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class R1_01M_SPEC_LIT
extends AbstractGuideline<Document> {
    private static final Logger logger = LoggerFactory.getLogger(R1_01M_SPEC_LIT.class);

    public R1_01M_SPEC_LIT() {
        super("meta(data) are richly described with a plurality of accurate and relevant attributes", "R1", "description", "https://w3id.org/fair/principles/latest/R1", "R", 1, RequirementLevel.MANDATORY);
    }

    public StandardResult validate(String id, Document t) {
        R1_01M_LIT profile = new R1_01M_LIT();
        try {
            StandardValidationResult res_F = profile.validate(id, t);
            Map<String, StandardResult> results = res_F.getResults();
            int MaxScoreR1_01M_SPEC = (int)(res_F.getScore() * (double)this.getWeight() / 100.0);
            ArrayList<String> warnings2 = new ArrayList<String>();
            ArrayList<String> errors2 = new ArrayList<String>();
            for (Map.Entry<String, StandardResult> entry : results.entrySet()) {
                String key = entry.getKey();
                String warningsStr = results.get(key).getWarnings().toString();
                String errorsStr = results.get(key).getErrors().toString();
                if (warningsStr.length() > 2) {
                    warnings2.add(warningsStr);
                }
                if (errorsStr.length() <= 2) continue;
                errors2.add(errorsStr);
            }
            StandardResult ress = R1_01M_SPEC_LIT.getResult(warnings2, errors2, MaxScoreR1_01M_SPEC);
            return new StandardResult(ress.getScore(), ress.getStatus(), ress.getWarnings(), ress.getErrors(), ress.getInternalError());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static StandardResult getResult(ArrayList<String> warnings2, ArrayList<String> errors2, int score2) {
        return ResultUtils.getNewResult(warnings2, errors2, score2);
    }
}

