/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public final class R1_2_01M
extends AbstractOpenAireProfile {
    private static final String[] NAME_IDENTIFIER_SCHEMES = new String[]{"ORCID", "ISNI", "ROR", "GRID"};
    private static final String[] CONTRIBUTOR_TYPES = new String[]{"ContactPerson", "DataCollector", "DataCurator", "DataManager", "Distributor", "Editor", "HostingInstitution", "Producer", "ProjectLeader", "ProjectManager", "ProjectMember", "RegistrationAgency", "RegistrationAuthority", "RelatedPerson", "Researcher", "ResearchGroup", "RightsHolder", "Sponsor", "Supervisor", "WorkPackageLeader", "Other"};
    private static final String[] DATE_TYPES = new String[]{"Accepted", "Available", "Copyrighted", "Collected", "Created", "Issued", "Submitted", "Updated", "Valid"};
    private static final String[] CONTRIBUTOR_NAME_IDENTIFIER_TYPES = new String[]{"Funder", "FundingProgramme", "ProjectID", "Jurisdiction", "ProjectName", "ProjectAcronym"};
    private static final String[] IDENTIFIER_TYPES = new String[]{"ARK", "arXiv", "bibcode", "DOI", "EAN13", "EISSN", "Handle", "IGSN", "ISBN", "ISSN", "ISTC", "LISSN", "LSID", "PISSN", "PMID", "PURL", "UPC", "URL", "URN", "WOS"};
    private static final String[] RELATION_TYPES_LIMITED = new String[]{"IsSupplementTo", "Describes", "IsMetadataFor", "IsPartOf"};
    private static final ElementSpec CREATOR_SPEC = Builders.forMandatoryElement("creator", Cardinality.ONE_TO_N).withSubElement(Builders.forMandatoryElement("creatorName", Cardinality.ONE)).withSubElement(Builders.forRecommendedElement("nameIdentifier").withMandatoryAttribute("nameIdentifierScheme").withMandatoryAttribute("schemeURI")).withSubElement(Builders.forRecommendedRepeatableElement("affiliation")).build();
    private static final ElementSpec CONTRIBUTOR_SPEC = Builders.forMandatoryElement("contributor", Cardinality.ONE_TO_N).withMandatoryAttribute("contributorType", CONTRIBUTOR_TYPES).withSubElement(Builders.forMandatoryIfApplicableElement("contributorName", Cardinality.ONE, AbstractOpenAireProfile.elementIsPresent("contributor"))).withMandatoryAttribute("nameIdentifier", CONTRIBUTOR_NAME_IDENTIFIER_TYPES).withMandatoryAttribute("affiliation").build();
    private static final ElementSpec PUBLICATION_DATE_SPEC = Builders.forMandatoryElement("date", Cardinality.ONE_TO_N).withMandatoryAttribute("dateType", DATE_TYPES).build();
    private static final ElementSpec RESOURCE_VERSION_SPEC = Builders.forMandatoryElement("version", Cardinality.ONE).build();
    private static final ElementSpec RELATED_IDENTIFIER_SPEC = Builders.forMandatoryElement("relatedIdentifier", Cardinality.ONE_TO_N).withMandatoryAttribute("relatedIdentifierType", IDENTIFIER_TYPES).withMandatoryAttribute("relationType", RELATION_TYPES_LIMITED).build();
    public static SyntheticGuideline R1_2_01M_1 = SyntheticGuideline.of("Creator", 4, CREATOR_SPEC);
    public static SyntheticGuideline R1_2_01M_2 = SyntheticGuideline.of("Contributor", 2, CONTRIBUTOR_SPEC);
    public static SyntheticGuideline R1_2_01M_3 = SyntheticGuideline.of("Date", 4, PUBLICATION_DATE_SPEC);
    public static SyntheticGuideline R1_2_01M_4 = SyntheticGuideline.of("Version", 2, RESOURCE_VERSION_SPEC);
    public static SyntheticGuideline R1_2_01M_5 = SyntheticGuideline.of("RelatedIdentifier", 2, RELATED_IDENTIFIER_SPEC);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(Arrays.asList(R1_2_01M_1, R1_2_01M_2, R1_2_01M_3, R1_2_01M_4, R1_2_01M_5));
    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.stream().collect(Collectors.toMap(Guideline::getName, guideline -> guideline));
    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    public R1_2_01M() {
        super("Metadata includes provenance information according to a cross-community language");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}

