/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.engine.contexts;

import eu.dnetlib.validator2.engine.Helper;
import eu.dnetlib.validator2.engine.RuleContext;
import eu.dnetlib.validator2.engine.contexts.BooleanRuleProperty;
import eu.dnetlib.validator2.engine.contexts.LongRuleProperty;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CardinalityContext
extends RuleContext {
    public static final Logger logger = LoggerFactory.getLogger(CardinalityContext.class);
    public static final String GREATER_THAN_PROPERTY_NAME = "gt";
    public static final String LESS_THAN_PROPERTY_NAME = "lt";
    public static final String UPPER_BOUND_PROPERTY_NAME = "lt";
    public static final String LOWER_BOUND_PROPERTY_NAME = "gt";
    public static final String IS_INCLUSIVE_PROPERTY_NAME = "inclusive";

    public LongRuleProperty getLowerBoundProperty();

    public LongRuleProperty getUpperBoundProperty();

    public BooleanRuleProperty getIsInclusiveProperty();

    default public Predicate<Integer> cardinalityPredicate() {
        logger.debug("Evaluating cardinality " + this.getIdProperty().getValue());
        long min = this.getLowerBoundProperty().getLongValue();
        long max = this.getUpperBoundProperty().getLongValue();
        return Helper.createCardinalityPredicate(min, max, this.getIsInclusiveProperty().isTrue());
    }
}

