/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline;

import eu.dnetlib.validator2.engine.Helper;
import eu.dnetlib.validator2.engine.Reporter;
import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.engine.RuleDiagnostics;
import eu.dnetlib.validator2.engine.RuleEngine;
import eu.dnetlib.validator2.engine.builtins.StandardRuleDiagnostics;
import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.Status;
import eu.dnetlib.validator2.validation.guideline.CompilationResult;
import eu.dnetlib.validator2.validation.guideline.SyntheticRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

class GuidelineEvaluation {
    private static final Logger logger = LoggerFactory.getLogger(GuidelineEvaluation.class);
    private static final RuleDiagnostics<Document, Rule<Document>> OUT = Helper.Diagnostics.systemOut();
    private static final RuleDiagnostics<Document, Rule<Document>> ERR = Helper.Diagnostics.systemErr();
    private final String subjectId;
    private final Document doc;
    private final int weight;
    private final List<String> warnings = new ArrayList<String>();
    private final List<String> errors = new ArrayList<String>();
    private final Map<String, RequirementLevel> ruleIdToRequirementLevel = new HashMap<String, RequirementLevel>();
    private final Map<String, NodeList> ruleIdToNodeList = new HashMap<String, NodeList>();
    private final Diagnostics diagnostics = new Diagnostics();
    private final Reporter<Document, SyntheticRule<Document>> reporter = new Reporter<Document, SyntheticRule<Document>>(this.diagnostics);
    private static final Pattern RULE_PATTERN = Pattern.compile("(The [\\w_]+ rule ')(?:([\\w:/]+)/)?([\\w:\\s]+)'(\\s(?:element|attribute))[\\w\\s]*,? has cardinality (\\w+(?:\\s?[-=]\\s?\\w+)?)");

    GuidelineEvaluation(String subjectId, Document doc, int weight) {
        this.subjectId = subjectId;
        this.doc = doc;
        this.weight = weight;
    }

    StandardResult evaluate(CompilationResult result) {
        this.ruleIdToRequirementLevel.putAll(result.ruleIdToRequirementLevel);
        ArrayList<SyntheticRule<Document>> rules = new ArrayList<SyntheticRule<Document>>();
        rules.add(result.rootNodeRule);
        rules.addAll(result.nodeRules);
        logger.debug("Evaluating " + rules);
        for (SyntheticRule syntheticRule : rules) {
            RuleEngine.applyAndReport(syntheticRule, this.doc, this.reporter);
            Status status = this.diagnostics.getLastReportedStatus();
            if (status == Status.ERROR) {
                return StandardResult.forError((String)this.diagnostics.getLastReportedError().getMessage());
            }
            String id = syntheticRule.getContext().getIdProperty().getValue();
            RequirementLevel requirementLevel = this.getRequirementLevelOf(id);
            if (status == Status.SUCCESS && requirementLevel == RequirementLevel.NOT_APPLICABLE) {
                logger.warn("Non-applicable: " + syntheticRule);
                this.warnings.add(this.synthesizeFailureMessage(syntheticRule));
                continue;
            }
            if (status != Status.FAILURE) continue;
            if (requirementLevel == RequirementLevel.MANDATORY || requirementLevel == RequirementLevel.MANDATORY_IF_APPLICABLE) {
                SyntheticRule parentRule = syntheticRule.parentRule();
                if (parentRule == null) {
                    logger.error("Fail fast for root failure: " + syntheticRule);
                    this.errors.add(this.synthesizeFailureMessage(syntheticRule));
                    return StandardResult.forFailure(this.warnings, this.errors);
                }
                RequirementLevel parentRequirementLevel = this.getRequirementLevelOf(parentRule.getContext().getIdProperty().getValue());
                if (parentRequirementLevel == RequirementLevel.MANDATORY || parentRequirementLevel == RequirementLevel.MANDATORY_IF_APPLICABLE) {
                    logger.error("Fail fast for root failure: " + syntheticRule);
                    this.errors.add(this.synthesizeFailureMessage(syntheticRule));
                    return StandardResult.forFailure(this.warnings, this.errors);
                }
                if (requirementLevel == RequirementLevel.MANDATORY) {
                    logger.warn("Mandatory failure: " + syntheticRule);
                } else {
                    logger.warn("Mandatory_If_Applicable failure: " + syntheticRule);
                }
                this.warnings.add(this.synthesizeFailureMessage(syntheticRule));
                continue;
            }
            if (requirementLevel == RequirementLevel.RECOMMENDED) {
                logger.warn("Recommended failure: " + syntheticRule);
            } else if (requirementLevel == RequirementLevel.OPTIONAL) {
                logger.warn("Optional failure: " + syntheticRule);
            } else {
                logger.error("UNKNOWN failure: " + syntheticRule);
            }
            this.warnings.add(this.synthesizeFailureMessage(syntheticRule));
        }
        int returnedWeight = this.weight;
        if (rules.size() == this.warnings.size()) {
            returnedWeight = 0;
        }
        return StandardResult.forSuccess((int)returnedWeight, this.warnings);
    }

    private String synthesizeFailureMessage(Rule<Document> rule) {
        Object ruleContext = rule.getContext();
        String ruleId = ruleContext.getIdProperty().getValue();
        RequirementLevel ruleRequirementLevel = this.getRequirementLevelOf(ruleId);
        String lastMessage = "";
        lastMessage = ruleRequirementLevel == RequirementLevel.OPTIONAL || ruleRequirementLevel == RequirementLevel.RECOMMENDED ? ", is not populated." : ", has failed.";
        Matcher matcher = RULE_PATTERN.matcher(ruleId);
        if (!matcher.find()) {
            logger.error("Could not find the ruleId: " + ruleId);
            return "The " + ruleRequirementLevel.toString().toLowerCase() + " rule " + Helper.stringify(rule) + lastMessage;
        }
        String introduction = null;
        introduction = matcher.group(1);
        if (introduction == null || introduction.trim().isEmpty()) {
            logger.error("Could not get the 'introduction' from ruleId: " + ruleId);
            return "The " + ruleRequirementLevel.toString().toLowerCase() + " rule " + Helper.stringify(rule) + lastMessage;
        }
        String parentElement = matcher.group(2);
        String currentElementOrAttribute = null;
        currentElementOrAttribute = matcher.group(3);
        if (currentElementOrAttribute == null || currentElementOrAttribute.trim().isEmpty()) {
            logger.error("Could not get the 'currentElementOrAttribute' from ruleId: " + ruleId);
            return "The " + ruleRequirementLevel.toString().toLowerCase() + " rule " + Helper.stringify(rule) + lastMessage;
        }
        String nodeType = null;
        nodeType = matcher.group(4);
        if (nodeType == null || nodeType.trim().isEmpty()) {
            logger.error("Could not get the 'nodeType' from ruleId: " + ruleId);
            return "The " + ruleRequirementLevel.toString().toLowerCase() + " rule " + Helper.stringify(rule) + lastMessage;
        }
        String cardinality = null;
        cardinality = matcher.group(5);
        if (cardinality == null || cardinality.trim().isEmpty()) {
            logger.error("Could not get the 'cardinality' from ruleId: " + ruleId);
            return "The " + ruleRequirementLevel.toString().toLowerCase() + " rule " + Helper.stringify(rule) + lastMessage;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(Helper.stringify(rule));
            logger.trace(ruleId);
        }
        return introduction + currentElementOrAttribute + "'" + nodeType.toLowerCase() + (parentElement != null ? " of the '" + parentElement + "' element" : "") + ", having occurrence " + cardinality + lastMessage;
    }

    private String synthesizeNotApplicableMessage(Rule<Document> rule) {
        return this.subjectId + ": rule " + Helper.stringify(rule) + " is not applicable";
    }

    void setNodesOf(String ruleId, NodeList nodes) {
        this.ruleIdToNodeList.put(ruleId, nodes);
    }

    NodeList getNodesOf(String ruleId) {
        return this.ruleIdToNodeList.get(ruleId);
    }

    void setRequirementLevelOf(String ruleId, RequirementLevel requirementLevel) {
        this.ruleIdToRequirementLevel.put(ruleId, requirementLevel);
    }

    RequirementLevel getRequirementLevelOf(String ruleId) {
        return this.ruleIdToRequirementLevel.get(ruleId);
    }

    public String toString() {
        return "GuidelineEvaluation{subjectId='" + this.subjectId + '\'' + ", doc=" + this.doc + ", weight=" + this.weight + ", warnings=" + this.warnings + ", errors=" + this.errors + ", ruleIdToRequirementLevel=" + this.ruleIdToRequirementLevel + ", ruleIdToNodeList=" + this.ruleIdToNodeList + ", diagnostics=" + this.diagnostics + ", reporter=" + this.reporter + '}';
    }

    private static final class Diagnostics
    extends StandardRuleDiagnostics<Document, SyntheticRule<Document>> {
        private final Map<String, Status> statusByRuleId = new HashMap<String, Status>();

        private Diagnostics() {
        }

        @Override
        public void success(SyntheticRule<Document> rule, Document document) {
            OUT.success(rule, document);
            super.success(rule, document);
            this.statusByRuleId.put(rule.getContext().getIdProperty().getValue(), Status.SUCCESS);
        }

        @Override
        public void failure(SyntheticRule<Document> rule, Document document) {
            OUT.failure(rule, document);
            super.failure(rule, document);
            this.statusByRuleId.put(rule.getContext().getIdProperty().getValue(), Status.FAILURE);
        }

        @Override
        public void error(SyntheticRule<Document> rule, Document document, Throwable err) {
            ERR.error(rule, document, err);
            super.error(rule, document, err);
            this.statusByRuleId.put(rule.getContext().getIdProperty().getValue(), Status.ERROR);
        }

        private Status statusFor(String ruleId) {
            return this.statusByRuleId.get(ruleId);
        }

        public String toString() {
            return "Diagnostics{statusByRuleId=" + this.statusByRuleId + '}';
        }
    }
}

