/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.StandardValidationResult;
import eu.dnetlib.validator2.validation.guideline.AbstractGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.R1_01M;
import eu.dnetlib.validator2.validation.utils.ResultUtils;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class R1_01M_SPEC
extends AbstractGuideline<Document> {
    private static final Logger logger = LoggerFactory.getLogger(R1_01M_SPEC.class);

    public R1_01M_SPEC() {
        super("meta(data) are richly described with a plurality of accurate and relevant attributes", "R1", "description", "https://w3id.org/fair/principles/latest/R1", "R", 12, RequirementLevel.MANDATORY);
    }

    public StandardResult validate(String id, Document t) {
        R1_01M profile = new R1_01M();
        try {
            StandardValidationResult res_F = profile.validate(id, t);
            Map results = res_F.getResults();
            int MaxScoreR1_01M_SPEC = (int)(res_F.getScore() * (double)this.getWeight() / 100.0);
            StandardResult ress = R1_01M_SPEC.getResult(results.entrySet(), -1);
            return new StandardResult(ress.getScore(), ress.getStatus(), ress.getWarnings(), ress.getErrors(), ress.getInternalError());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static StandardResult getResult(Set<Map.Entry<String, StandardResult>> data, int score) {
        return ResultUtils.getNewResult(data, score);
    }
}

