/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.utils;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class MediaTypes {
    private static Set<String> mediaTypes;

    private static void loadMediaTypes() {
        try (InputStream in = MediaTypes.class.getClassLoader().getResourceAsStream("mediaTypes.csv");){
            List<String> l = Arrays.asList(IOUtils.toString((InputStream)in, (String)"UTF-8").split("\\s*,\\s*"));
            mediaTypes = new HashSet<String>(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean contains(String mediaType) {
        if (mediaTypes == null) {
            throw new IllegalStateException("Media types not loaded from file");
        }
        if (mediaType == null || mediaType.isEmpty()) {
            return false;
        }
        return mediaTypes.contains(mediaType);
    }

    static {
        MediaTypes.loadMediaTypes();
    }
}

