/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.StandardValidationResult;
import eu.dnetlib.validator2.validation.guideline.AbstractGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.F2_01M;
import eu.dnetlib.validator2.validation.utils.ResultUtils;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class F2_01M_SPEC
extends AbstractGuideline<Document> {
    private static final Logger logger = LoggerFactory.getLogger(F2_01M_SPEC.class);

    public F2_01M_SPEC() {
        super("data are described with rich metadata", "F2", "description", "https://w3id.org/fair/principles/latest/F2", "F", 10, RequirementLevel.MANDATORY);
    }

    public StandardResult validate(String id, Document t) {
        F2_01M profile = new F2_01M();
        try {
            StandardValidationResult res_F = profile.validate(id, t);
            Map results = res_F.getResults();
            int MaxScoreF2_01M_SPEC = (int)(res_F.getScore() * (double)this.getWeight() / 100.0);
            logger.debug("Max score DataValidator(%): " + res_F.getScore());
            logger.debug("Weight FAIRG: " + this.getWeight());
            logger.debug("Max score F2_01M_SPEC: " + MaxScoreF2_01M_SPEC);
            StandardResult ress = F2_01M_SPEC.getResult(results.entrySet(), MaxScoreF2_01M_SPEC);
            return new StandardResult(ress.getScore(), ress.getStatus(), ress.getWarnings(), ress.getErrors(), ress.getInternalError());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static StandardResult getResult(Set<Map.Entry<String, StandardResult>> data, int score) {
        return ResultUtils.getNewResult(data, score);
    }
}

