/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.engine;

import eu.dnetlib.validator2.engine.Helper;
import eu.dnetlib.validator2.engine.Rule;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Predicates {
    public static <T> Predicate<T> all(Iterable<Rule<T>> rules) {
        return t -> {
            for (Predicate predicate : rules) {
                if (predicate.test(t)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> any(Iterable<Rule<T>> rules) {
        return t -> {
            for (Predicate predicate : rules) {
                if (!predicate.test(t)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> Predicate<T> not(Rule<T> rule) {
        return t -> !rule.test(t);
    }

    public static class SetOfCaseInsensitiveAllowedValues
    implements Predicate<String> {
        private final Set<String> allowedValues;

        public SetOfCaseInsensitiveAllowedValues(String[] allowedValues) {
            this.allowedValues = Stream.of(allowedValues).filter(Objects::nonNull).map(String::trim).filter(term -> !term.isEmpty()).map(String::toLowerCase).collect(Collectors.toCollection(HashSet::new));
        }

        @Override
        public boolean test(String s) {
            String textToTest = Helper.canonicalize(s);
            if (textToTest.isEmpty()) {
                return false;
            }
            return this.allowedValues.contains(textToTest.toLowerCase());
        }

        public boolean isEmpty() {
            return this.allowedValues.isEmpty();
        }

        public String toString() {
            return "SetOfCaseInsensitiveAllowedValues{allowedValues=" + this.allowedValues + '}';
        }
    }
}

