/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.ElementPosition;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validator2.validation.guideline.openaire.F2_01M_SPEC;
import eu.dnetlib.validator2.validation.guideline.openaire.F3_01M_SPEC;
import eu.dnetlib.validator2.validation.guideline.openaire.F4M_SPEC;
import eu.dnetlib.validator2.validation.guideline.openaire.I1M_SPEC;
import eu.dnetlib.validator2.validation.guideline.openaire.I2_01M_SPEC;
import eu.dnetlib.validator2.validation.guideline.openaire.R1_01M_SPEC;
import eu.dnetlib.validator2.validation.guideline.openaire.R1_2_01M_SPEC;
import eu.dnetlib.validator2.validation.guideline.openaire.R1_3_01M_SPEC;
import eu.dnetlib.validator2.validation.utils.RegexValuePredicate;
import eu.dnetlib.validator2.validation.utils.SupportedRegExs;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public final class FAIR_Data_GuidelinesProfile
extends AbstractOpenAireProfile {
    private static final Logger logger = LoggerFactory.getLogger(FAIR_Data_GuidelinesProfile.class);
    private static final String[] rightsURIList = new String[]{"info:eu-repo/semantics/closedAccess", "info:eu-repo/semantics/embargoedAccess", "info:eu-repo/semantics/restrictedAccess", "info:eu-repo/semantics/openAccess"};
    private static final String[] IDENTIFIER_TYPES = new String[]{"ARK", "arXiv", "bibcode", "DOI", "EAN13", "EISSN", "Handle", "IGSN", "ISBN", "ISSN", "ISTC", "LISSN", "ISSNL", "LSID", "PISSN", "PMID", "PURL", "UPC", "URL", "URN", "WOS"};
    private static final String[] RELATION_TYPES = new String[]{"IsCitedBy", "Cites", "IsSupplementTo", "IsSupplementedBy", "IsContinuedBy", "Continues", "IsDescribedBy", "Describes", "HasMetadata", "IsMetadataFor", "HasVersion", "IsVersionOf", "IsNewVersionOf", "IsPreviousVersionOf", "IsPartOf", "HasPart", "IsReferencedBy", "References", "IsDocumentedBy", "Documents", "IsCompiledBy", "Compiles", "IsVariantFormOf", "IsOriginalFormOf", "IsIdenticalTo", "IsReviewedBy", "Reviews", "IsDerivedFrom", "IsSourceOf", "IsRequiredBy", "Requires"};
    private static final String[] RESOURCE_IDENTIFIER_TYPES = new String[]{"ARK", "DOI", "Handle", "IGSN", "arXiv", "PURL", "URL", "URN", "PMID"};
    private static final ElementSpec F1_01D_SPEC = Builders.forMandatoryElement("identifier", Cardinality.ONE).inContext("metadata", "oai_datacite", "payload", "resource").withMandatoryAttribute("identifierType", RESOURCE_IDENTIFIER_TYPES).build();
    private static final ElementSpec A1_01M_SPEC = Builders.forMandatoryElement("rights", Cardinality.ONE_TO_N).withMandatoryAttribute("rightsURI", rightsURIList).build();
    private static final ElementSpec I3_01M_SPEC_1 = Builders.forMandatoryElement("relatedIdentifier", Cardinality.ONE_TO_N).withMandatoryAttribute("relatedIdentifierType", IDENTIFIER_TYPES).withMandatoryAttribute("relationType", RELATION_TYPES).build();
    private static final ElementSpec R1_1_01M_SPEC = Builders.forMandatoryElement("rights", Cardinality.ONE_TO_N).atPosition(ElementPosition.FIRST).withMandatoryAttribute("rightsURI").allowedValues(new RegexValuePredicate(SupportedRegExs.COMPILED_LICENSE_CONDITION_REG_EX)).build();
    public static SyntheticGuideline F1_01D = SyntheticGuideline.of("(meta)data are assigned a globally unique and persistent identifier", "F1", "description", "https://w3id.org/fair/principles/latest/F1", "F", 10, RequirementLevel.MANDATORY, F1_01D_SPEC);
    public static SyntheticGuideline A1_01M = SyntheticGuideline.of("(meta)data are retrievable by their identifier using a standardized communications protocol", "A1", "description", "https://w3id.org/fair/principles/latest/A1", "A", 10, RequirementLevel.MANDATORY, F1_01D_SPEC);
    public static SyntheticGuideline A1_01_1M = SyntheticGuideline.of("the protocol is open, free, and universally implementable", "A1.1", "description", "https://w3id.org/fair/principles/latest/A1.1", "A", 10, RequirementLevel.MANDATORY, F1_01D_SPEC);
    public static SyntheticGuideline I3_01M_1 = SyntheticGuideline.of("(meta)data include qualified references to other (meta)data", "I3", "description", "https://w3id.org/fair/principles/latest/I3", "I", 10, RequirementLevel.MANDATORY, I3_01M_SPEC_1);
    public static SyntheticGuideline R1_1_01M = SyntheticGuideline.of("(meta)data are released with a clear and accessible data usage license", "R1.1", "description", "https://w3id.org/fair/principles/latest/R1.1", "R", 10, RequirementLevel.MANDATORY, R1_1_01M_SPEC);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(Arrays.asList(F1_01D, new F2_01M_SPEC(), new F3_01M_SPEC(), new F4M_SPEC(), A1_01M, A1_01_1M, new I1M_SPEC(), new I2_01M_SPEC(), I3_01M_1, new R1_01M_SPEC(), R1_1_01M, new R1_2_01M_SPEC(), new R1_3_01M_SPEC()));
    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.stream().collect(Collectors.toMap(Guideline::getName, guideline -> guideline));
    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    public FAIR_Data_GuidelinesProfile() {
        super("OpenAIRE FAIR Guidelines for Data Repositories Profile");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}

