/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.utils;

import eu.dnetlib.validator2.validation.utils.MediaTypes;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class ISOLangCodes {
    private static Set<String> langs;

    private static void loadLangCodes() {
        try (InputStream in = MediaTypes.class.getClassLoader().getResourceAsStream("iso639XLangCodes.csv");){
            List<String> l = Arrays.asList(IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8).split("\\s*,\\s*"));
            langs = new HashSet<String>(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean contains(String langCode) {
        if (langs == null) {
            throw new IllegalStateException("Languages  not loaded from file");
        }
        if (langCode == null || langCode.isEmpty()) {
            return false;
        }
        return langs.contains(langCode);
    }

    static {
        ISOLangCodes.loadLangCodes();
    }
}

