/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.engine.builtins;

import eu.dnetlib.validator2.engine.RuleValidationResult;
import eu.dnetlib.validator2.engine.TestResultPredicate;
import eu.dnetlib.validator2.engine.builtins.AbstractRuleBuilder;
import eu.dnetlib.validator2.engine.builtins.StandardXMLContextWithVocabulary;
import eu.dnetlib.validator2.engine.builtins.XMLRule;
import eu.dnetlib.validator2.engine.contexts.TermsProperty;
import eu.dnetlib.validator2.engine.contexts.XMLContextWithVocabulary;
import java.util.Map;
import org.w3c.dom.NodeList;

public class XMLVocabularyRule
extends XMLRule<XMLContextWithVocabulary> {
    protected XMLVocabularyRule(XMLContextWithVocabulary context) {
        super(context, nodes -> {
            TermsProperty terms = context.getTermsProperty();
            String termsType = context.getTermsTypeProperty().getValue().toLowerCase();
            TestResultPredicate<String> termExistsPredicate = value -> {
                if (terms.termExists((String)value)) {
                    return RuleValidationResult.success();
                }
                return RuleValidationResult.failure("Value '" + value + "' not found in vocabulary.");
            };
            RuleValidationResult result = context.getNodeListActionProperty().test((NodeList)nodes, termExistsPredicate);
            if (termsType.equals("blacklist")) {
                if (result.isSuccess()) {
                    return RuleValidationResult.failure("Value found in blacklist: " + result.getMessage());
                }
                return RuleValidationResult.success();
            }
            return result;
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractRuleBuilder<XMLVocabularyRule, XMLContextWithVocabulary> {
        private Builder() {
            super(new StandardXMLContextWithVocabulary());
        }

        public Builder setId(String id) {
            ((XMLContextWithVocabulary)this.context).getIdProperty().setValue(id);
            return this;
        }

        public Builder setXPathExpression(String xpath) {
            ((XMLContextWithVocabulary)this.context).getXPathExpressionProperty().setValue(xpath);
            return this;
        }

        public Builder setNodeListAction(String nodeListAction) throws RuntimeException {
            ((XMLContextWithVocabulary)this.context).getNodeListActionProperty().setValue(nodeListAction);
            return this;
        }

        public Builder setVocabularyTerms(String terms) {
            ((XMLContextWithVocabulary)this.context).getTermsProperty().setValue(terms);
            return this;
        }

        public Builder setVocabularyTermsAndTermsType(String terms, String termsType) {
            ((XMLContextWithVocabulary)this.context).getTermsProperty().setValue(terms);
            ((XMLContextWithVocabulary)this.context).getTermsTypeProperty().setValue(termsType);
            return this;
        }

        private void initializeOptionalTermsTypeProperty() {
            if (((XMLContextWithVocabulary)this.context).getTermsTypeProperty().getValue() == null) {
                ((XMLContextWithVocabulary)this.context).getTermsTypeProperty().setValue("blacklist");
            }
        }

        @Override
        public XMLVocabularyRule build() {
            this.initializeOptionalTermsTypeProperty();
            this.ensureContextIsValid();
            return new XMLVocabularyRule((XMLContextWithVocabulary)this.context);
        }

        @Override
        public XMLVocabularyRule buildFrom(Map<String, String> map) {
            ((XMLContextWithVocabulary)this.context).readFrom(map);
            this.initializeOptionalTermsTypeProperty();
            this.ensureContextIsValid();
            return new XMLVocabularyRule((XMLContextWithVocabulary)this.context);
        }
    }
}

