/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.task;

import eu.dnetlib.validator2.engine.Reporter;
import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.engine.RuleEngine;
import eu.dnetlib.validator2.validation.task.AbstractValidationTask;
import eu.dnetlib.validator2.validation.task.ValidatorDiagnostics;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class ExecutorBasedValidationTask<T, R extends Rule<T>>
extends AbstractValidationTask<T, R> {
    protected final ExecutorService executor;

    protected ExecutorBasedValidationTask(T subject, Collection<R> rules, ExecutorService executor) {
        super(subject, rules);
        this.executor = executor;
    }

    @Override
    protected void applyRulesAndReport(ValidatorDiagnostics<T, R> outputs) {
        try {
            HashMap rulesToFutures = new HashMap();
            Reporter<T, R> reporter = new Reporter<T, R>(outputs);
            for (Rule rule : this.rules) {
                Future<?> future = this.executor.submit(() -> RuleEngine.applyAndReport(rule, this.subject, reporter));
                rulesToFutures.put(rule.getContext().getIdProperty().getValue(), future);
            }
            for (Map.Entry entry : rulesToFutures.entrySet()) {
                try {
                    ((Future)entry.getValue()).get();
                }
                catch (InterruptedException ie) {
                    outputs.setInterrupted((String)entry.getKey());
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Internal error", t);
        }
    }
}

