/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.utils;

import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResultUtils.class);

    public static StandardResult getNewResult(Set<Map.Entry<String, StandardResult>> data, int score2) {
        boolean shouldAssignScoreInLoop;
        boolean bl = shouldAssignScoreInLoop = score2 == -1;
        if (shouldAssignScoreInLoop) {
            score2 = 0;
        }
        ArrayList<String> warnings2 = new ArrayList<String>();
        ArrayList<String> errors2 = new ArrayList<String>();
        for (Map.Entry<String, StandardResult> entry : data) {
            String key = entry.getKey();
            StandardResult standardResult = entry.getValue();
            String warningsStr = standardResult.getWarnings().toString();
            String errorsStr = standardResult.getErrors().toString();
            if (warningsStr.length() > 2) {
                warnings2.add(warningsStr);
            }
            if (errorsStr.length() > 2) {
                errors2.add(errorsStr);
            }
            if (shouldAssignScoreInLoop && standardResult.toString().contains("SUCCESS")) {
                score2 += 3;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace(String.valueOf(standardResult.getWarnings().getClass()));
            logger.trace(String.valueOf(warnings2.getClass()));
        }
        StandardResult result = new StandardResult(){
            private int score;
            private Status status;
            private List<String> warnings;
            private List<String> errors;
            private String internalError;

            public int getScore() {
                return this.score;
            }

            public void setScore(int score) {
                this.score = score;
            }

            public Status getStatus() {
                return this.status;
            }

            public void setStatus(Status status) {
                this.status = status;
            }

            public List<String> getWarnings() {
                return this.warnings;
            }

            public void setWarnings(List<String> warnings) {
                this.warnings = warnings;
            }

            public List<String> getErrors() {
                return this.errors;
            }

            public void setErrors(List<String> errors) {
                this.errors = errors;
            }

            public String getInternalError() {
                return this.internalError;
            }

            public void setInternalError(String internalError) {
                this.internalError = internalError;
            }
        };
        result.setScore(score2);
        result.setStatus(Status.valueOf((String)(score2 > 0 ? "SUCCESS" : "FAILURE")));
        result.setWarnings(warnings2);
        result.setErrors(errors2);
        return result;
    }
}

