/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.engine.builtins;

import eu.dnetlib.validator2.engine.Helper;
import eu.dnetlib.validator2.engine.RuleProperty;
import java.util.Map;

public class StandardRuleProperty
implements RuleProperty {
    private final String name;
    private String value;

    public StandardRuleProperty(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void readFrom(Map<String, String> map) {
        if (map.containsKey(this.getName())) {
            this.setValue(map.get(this.getName()));
        }
    }

    @Override
    public void writeTo(Map<String, String> map) {
        map.put(this.name, this.getValue());
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) throws IllegalArgumentException {
        String newValue = Helper.canonicalize(value);
        if (newValue.isEmpty()) {
            throw new IllegalArgumentException("Empty value for property " + this.name);
        }
        this.value = newValue;
    }

    public String toString() {
        return "StandardRuleProperty{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
    }
}

