/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.engine.builtins.XMLVocabularyRule;
import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validator2.validation.utils.RegexValuePredicate;
import eu.dnetlib.validator2.validation.utils.SupportedRegExs;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public final class R1_2_01M_LIT
extends AbstractOpenAireProfile {
    private static final String[] NAME_IDENTIFIER_SCHEMES = new String[]{"ORCID", "ISNI", "ROR", "GRID"};
    private static final String[] CONTRIBUTOR_TYPES = new String[]{"ContactPerson", "DataCollector", "DataCurator", "DataManager", "Distributor", "Editor", "HostingInstitution", "Producer", "ProjectLeader", "ProjectManager", "ProjectMember", "RegistrationAgency", "RegistrationAuthority", "RelatedPerson", "Researcher", "ResearchGroup", "RightsHolder", "Sponsor", "Supervisor", "WorkPackageLeader", "Other"};
    private static final String[] DATE_TYPES = new String[]{"Accepted", "Available", "Issued"};
    private static final String[] CONTRIBUTOR_NAME_IDENTIFIER_TYPES = new String[]{"Funder", "FundingProgramme", "ProjectID", "Jurisdiction", "ProjectName", "ProjectAcronym"};
    private static final String[] IDENTIFIER_TYPES = new String[]{"ARK", "arXiv", "bibcode", "DOI", "EAN13", "EISSN", "Handle", "IGSN", "ISBN", "ISSN", "ISTC", "LISSN", "ISSNL", "LSID", "PISSN", "PMID", "PURL", "UPC", "URL", "URN", "WOS"};
    private static final String[] RELATION_TYPES_LIMITED = new String[]{"IsSupplementTo", "IsSupplementedBy", "IsContinuedBy", "Continues", "IsDescribedBy", "Describes", "HasMetadata", "IsMetadataFor", "HasVersion", "IsVersionOf", "IsNewVersionOf", "IsPreviousVersionOf", "IsPartOf", "HasPart", "IsDocumentedBy", "Documents", "IsCompiledBy", "Compiles", "IsVariantFormOf", "IsOriginalFormOf", "IsIdenticalTo", "IsDerivedFrom", "IsSourceOf"};
    private static final String[] NAME_TYPES = new String[]{"Organizational", "Personal"};
    private static final String[] RESOURCE_VERSION_URIS = new String[]{"http://purl.org/coar/version/c_b1a7d7d4d402bcce", "http://purl.org/coar/version/c_71e4c1898caa6e32", "http://purl.org/coar/version/c_ab4af688f83e57aa", "http://purl.org/coar/version/c_fa2ee174bc00049f", "http://purl.org/coar/version/c_970fb48d4fbd8a85", "http://purl.org/coar/version/c_e19f295774971610", "http://purl.org/coar/version/c_dc82b40f9837b551", "http://purl.org/coar/version/c_be7fb7dd8ff6fe43"};
    private static final String[] RELATION_TYPES = new String[]{"IsCitedBy", "Cites", "IsSupplementTo", "IsSupplementedBy", "IsContinuedBy", "Continues", "IsDescribedBy", "Describes", "HasMetadata", "IsMetadataFor", "HasVersion", "IsVersionOf", "IsNewVersionOf", "IsPreviousVersionOf", "IsPartOf", "HasPart", "IsReferencedBy", "References", "IsDocumentedBy", "Documents", "IsCompiledBy", "Compiles", "IsVariantFormOf", "IsOriginalFormOf", "IsIdenticalTo", "IsReviewedBy", "Reviews", "IsDerivedFrom", "IsSourceOf", "IsRequiredBy", "Requires"};
    private static final String[] RESOURCE_VERSION_LABELS = new String[]{"AO", "SMUR", "AM", "P", "VoR", "CVoR", "EVoR", "NA"};
    private static final String[] RELATED_RESOURCE_GENERAL_TYPES = new String[]{"Audiovisual", "Collection", "DataPaper", "Dataset", "Event", "Image", "InteractiveResource", "Model", "PhysicalObject", "Service", "Software", "Sound", "Text", "Workflow", "Other"};
    private static final ElementSpec CREATOR_SPEC = Builders.forMandatoryElement("datacite:creator", Cardinality.ONE_TO_N).withSubElement(Builders.forMandatoryElement("datacite:creatorName", Cardinality.ONE).withRecommendedAttribute("nameType", NAME_TYPES)).withSubElement(Builders.forRecommendedElement("datacite:givenName")).withSubElement(Builders.forRecommendedElement("datacite:familyName")).withSubElement(Builders.forRecommendedRepeatableElement("datacite:nameIdentifier").withMandatoryAttribute("nameIdentifierScheme", NAME_IDENTIFIER_SCHEMES).withRecommendedAttribute("schemeURI")).withSubElement(Builders.forRecommendedRepeatableElement("datacite:affiliation")).build();
    private static final ElementSpec CONTRIBUTOR_SPEC = Builders.forMandatoryIfApplicableElement("datacite:contributor", Cardinality.ONE_TO_N, R1_2_01M_LIT.elementIsPresent("datacite:contributor")).withMandatoryAttribute("contributorType", CONTRIBUTOR_TYPES).withSubElement(Builders.forMandatoryElement("datacite:contributorName", Cardinality.ONE).withRecommendedAttribute("nameType", NAME_TYPES)).withSubElement(Builders.forOptionalElement("datacite:familyName")).withSubElement(Builders.forOptionalElement("datacite:givenName")).withSubElement(Builders.forRecommendedRepeatableElement("datacite:nameIdentifier").withMandatoryAttribute("nameIdentifierScheme", NAME_IDENTIFIER_SCHEMES).withRecommendedAttribute("schemeURI")).withSubElement(Builders.forRecommendedRepeatableElement("datacite:affiliation")).build();
    private static final ElementSpec PUBLICATION_DATE_SPEC = Builders.forMandatoryElement("datacite:date", Cardinality.ONE_TO_N).withMandatoryAttribute("dateType", DATE_TYPES).allowedValues(new RegexValuePredicate(SupportedRegExs.COMPILED_PUBLICATION_DATE_REG_EX).or(new RegexValuePredicate(SupportedRegExs.COMPILED_YYYY_MM_DD_RANGE_REGEX).or(new RegexValuePredicate(SupportedRegExs.COMPILED_YEAR_YYYY_REG_EX)))).build();
    private static final ElementSpec RESOURCE_VERSION_SPEC = Builders.forRecommendedElement("oaire:version").withMandatoryIfApplicableAttribute("uri", R1_2_01M_LIT.applicabilityRuleForURIAttributeOfResourceVersion(), RESOURCE_VERSION_URIS).build();
    private static final ElementSpec RELATED_IDENTIFIER_SPEC = Builders.forRecommendedRepeatableElement("datacite:relatedIdentifier").withMandatoryAttribute("relatedIdentifierType", IDENTIFIER_TYPES).withMandatoryAttribute("relationType", RELATION_TYPES_LIMITED).withOptionalAttribute("relatedMetadataScheme").withOptionalAttribute("schemeURI").withOptionalAttribute("schemeType").withOptionalAttribute("resourceTypeGeneral", RELATED_RESOURCE_GENERAL_TYPES).build();
    public static SyntheticGuideline R1_2_01M_LIT_1 = SyntheticGuideline.of("Creator", 4, CREATOR_SPEC);
    public static SyntheticGuideline R1_2_01M_LIT_2 = SyntheticGuideline.of("Contributor", 2, CONTRIBUTOR_SPEC);
    public static SyntheticGuideline R1_2_01M_LIT_3 = SyntheticGuideline.of("Date", 4, PUBLICATION_DATE_SPEC);
    public static SyntheticGuideline R1_2_01M_LIT_4 = SyntheticGuideline.of("Version", 2, RESOURCE_VERSION_SPEC);
    public static SyntheticGuideline R1_2_01M_LIT_5 = SyntheticGuideline.of("RelatedIdentifier", 2, RELATED_IDENTIFIER_SPEC);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(Arrays.asList(R1_2_01M_LIT_1, R1_2_01M_LIT_2, R1_2_01M_LIT_3, R1_2_01M_LIT_4, R1_2_01M_LIT_5));
    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.stream().collect(Collectors.toMap(Guideline::getName, guideline -> guideline));
    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    private static Rule<Document> applicabilityRuleForURIAttributeOfResourceVersion() {
        return XMLVocabularyRule.builder().setId("ApplicabilityRule").setXPathExpression("//*[name()='oaire:version']/text()").setNodeListAction("1").setVocabularyTermsAndTermsType(String.join((CharSequence)", ", RESOURCE_VERSION_LABELS), "whitelist").build();
    }

    public R1_2_01M_LIT() {
        super("(meta)data are associated with detailed provenance");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}

