/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.task;

import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.engine.RuleDiagnostics;
import eu.dnetlib.validator2.validation.task.RuleEvaluationResult;
import eu.dnetlib.validator2.validation.task.ValidationTaskOutput;
import java.util.concurrent.ConcurrentHashMap;

class ValidatorDiagnostics<T, R extends Rule<T>>
implements RuleDiagnostics<T, R>,
ValidationTaskOutput {
    private final ConcurrentHashMap<String, RuleEvaluationResult> results = new ConcurrentHashMap();

    ValidatorDiagnostics() {
    }

    @Override
    public RuleEvaluationResult statusFor(String ruleId) {
        return this.results.get(ruleId);
    }

    @Override
    public long score() {
        return 0L;
    }

    void setInterrupted(String ruleId) {
        this.results.put(ruleId, RuleEvaluationResult.forInterrupted());
    }

    @Override
    public void success(R rule, T t) {
        this.results.put(rule.getContext().getIdProperty().getValue(), RuleEvaluationResult.forSuccess());
    }

    @Override
    public void failure(R rule, T t, String message) {
        this.results.put(rule.getContext().getIdProperty().getValue(), RuleEvaluationResult.forFailure(message));
    }

    @Override
    public void error(R rule, T t, Throwable err) {
        this.results.put(rule.getContext().getIdProperty().getValue(), RuleEvaluationResult.forError(err.getMessage()));
    }

    public String toString() {
        return "ValidatorDiagnostics{results=" + this.results + '}';
    }
}

