/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline;

import eu.dnetlib.validator2.engine.Helper;
import eu.dnetlib.validator2.engine.Reporter;
import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.engine.RuleDiagnostics;
import eu.dnetlib.validator2.engine.RuleEngine;
import eu.dnetlib.validator2.engine.builtins.StandardRuleDiagnostics;
import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.Status;
import eu.dnetlib.validator2.validation.guideline.CompilationResult;
import eu.dnetlib.validator2.validation.guideline.SyntheticRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class GuidelineEvaluation {
    private static final Logger logger = LoggerFactory.getLogger(GuidelineEvaluation.class);
    private static final RuleDiagnostics<Document, Rule<Document>> OUT = Helper.Diagnostics.systemOut();
    private static final RuleDiagnostics<Document, Rule<Document>> ERR = Helper.Diagnostics.systemErr();
    private final String subjectId;
    private final Document doc;
    private final int weight;
    private final List<String> warnings = new ArrayList<String>();
    private final List<String> errors = new ArrayList<String>();
    private final Map<String, RequirementLevel> ruleIdToRequirementLevel = new HashMap<String, RequirementLevel>();
    private final Map<String, NodeList> ruleIdToNodeList = new HashMap<String, NodeList>();
    private final Diagnostics diagnostics = new Diagnostics();
    private final Reporter<Document, SyntheticRule<Document>> reporter = new Reporter<Document, SyntheticRule<Document>>(this.diagnostics);
    private static final Pattern RULE_PATTERN = Pattern.compile("(The [\\w_]+ rule: ')(?:([\\w:/]+)/)?([\\w:\\s]+)'(\\s(?:element|attribute))[\\w\\s]*,? has cardinality (\\w+(?:-\\w+)?)");

    GuidelineEvaluation(String subjectId, Document doc, int weight) {
        this.subjectId = subjectId;
        this.doc = doc;
        this.weight = weight;
    }

    StandardResult evaluate(CompilationResult result) {
        this.ruleIdToRequirementLevel.putAll(result.ruleIdToRequirementLevel);
        ArrayList<SyntheticRule<Document>> rules = new ArrayList<SyntheticRule<Document>>();
        rules.add(result.rootNodeRule);
        rules.addAll(result.nodeRules);
        logger.debug("Evaluating " + rules);
        for (SyntheticRule syntheticRule : rules) {
            RuleEngine.applyAndReport(syntheticRule, this.doc, this.reporter);
            Status status = this.diagnostics.getLastReportedStatus();
            if (status == Status.ERROR) {
                return StandardResult.forError((String)this.diagnostics.getLastReportedError().getMessage());
            }
            String id = syntheticRule.getContext().getIdProperty().getValue();
            RequirementLevel requirementLevel = this.getRequirementLevelOf(id);
            if (status == Status.SUCCESS && requirementLevel == RequirementLevel.NOT_APPLICABLE) {
                logger.warn("Non-applicable: " + id);
                this.warnings.add(this.synthesizeNotApplicableMessage(syntheticRule));
                continue;
            }
            if (status != Status.FAILURE) continue;
            if (requirementLevel == RequirementLevel.MANDATORY || requirementLevel == RequirementLevel.MANDATORY_IF_APPLICABLE) {
                SyntheticRule<Document> parentRule = syntheticRule.parentRule();
                if (parentRule == null) {
                    logger.error("Important error for root failure: " + id + " -> " + this.diagnostics.lastFailureMessage);
                    this.errors.add(this.synthesizeFailureMessage(syntheticRule));
                    continue;
                }
                String parentRuleId = parentRule.getContext().getIdProperty().getValue();
                RequirementLevel parentRequirementLevel = this.getRequirementLevelOf(parentRuleId);
                if (parentRequirementLevel == RequirementLevel.MANDATORY || parentRequirementLevel == RequirementLevel.MANDATORY_IF_APPLICABLE) {
                    logger.error("Important error for main element failure: " + id + " -> " + this.diagnostics.lastFailureMessage);
                    this.errors.add(this.synthesizeFailureMessage(syntheticRule));
                    continue;
                }
                if (this.diagnostics.statusFor(parentRuleId) == Status.FAILURE && !this.isRulePopulated(parentRule, null, null)) {
                    logger.info("Suppressing warning for mandatory rule with unpopulated optional/recommended parent: " + syntheticRule);
                    continue;
                }
                logger.warn("Mandatory " + (requirementLevel == RequirementLevel.MANDATORY_IF_APPLICABLE ? "_If_Applicable" : "") + " failure: " + syntheticRule);
                this.warnings.add(this.synthesizeFailureMessage(syntheticRule));
                continue;
            }
            if (requirementLevel == RequirementLevel.RECOMMENDED) {
                logger.warn("Recommended failure: " + syntheticRule);
            } else if (requirementLevel == RequirementLevel.OPTIONAL) {
                logger.warn("Optional failure: " + syntheticRule);
            } else {
                logger.error("UNKNOWN failure: " + syntheticRule);
            }
            this.warnings.add(this.synthesizeFailureMessage(syntheticRule));
        }
        if (!this.errors.isEmpty()) {
            return StandardResult.forFailure(this.warnings, this.errors);
        }
        int returnedWeight = this.weight;
        if (rules.size() == this.warnings.size()) {
            returnedWeight = 0;
        }
        return StandardResult.forSuccess((int)returnedWeight, this.warnings);
    }

    private boolean isRulePopulated(SyntheticRule<Document> rule, String nodeType, String elementOrAttribute) {
        SyntheticRule<Document> parentRule;
        Matcher matcher = null;
        if (nodeType == null) {
            String ruleId = rule.getContext().getIdProperty().getValue();
            matcher = RULE_PATTERN.matcher(ruleId);
            if (!matcher.find()) {
                return false;
            }
            nodeType = matcher.group(4);
            if (nodeType == null) {
                return false;
            }
            nodeType = nodeType.trim();
        }
        if (nodeType.equals("element")) {
            NodeList testedNodes = rule.getTestedNodes();
            return testedNodes != null && testedNodes.getLength() > 0;
        }
        if (nodeType.equals("attribute") && (parentRule = rule.parentRule()) != null) {
            int numParentNodes;
            NodeList parentNodes = this.getNodesOf(parentRule.getContext().getIdProperty().getValue());
            int n = numParentNodes = parentNodes != null ? parentNodes.getLength() : 0;
            if (numParentNodes > 0) {
                if (elementOrAttribute == null && (elementOrAttribute = matcher.group(3)) == null) {
                    return false;
                }
                String[] pathParts = elementOrAttribute.split("/");
                String attrName = pathParts[pathParts.length - 1];
                for (int i = 0; i < numParentNodes; ++i) {
                    Node parentNode = parentNodes.item(i);
                    if (parentNode.getNodeType() != 1 || !((Element)parentNode).hasAttribute(attrName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private String synthesizeMainMessage(Rule<Document> rule, String failureMessage) {
        String elementOrAttribute;
        String ruleId = rule.getContext().getIdProperty().getValue();
        Matcher matcher = RULE_PATTERN.matcher(ruleId);
        if (!matcher.find()) {
            logger.error("Unknown rule ID detected. Falling back to simple message for: " + ruleId);
            return ruleId + ", has failed";
        }
        String introduction = matcher.group(1);
        if (introduction == null || (introduction = introduction.trim()).isEmpty()) {
            logger.error("Could not get the 'introduction' from ruleId: " + ruleId);
            return ruleId + ", has failed";
        }
        String parentElement = matcher.group(2);
        if (parentElement != null && (parentElement = parentElement.trim()).isEmpty()) {
            parentElement = null;
        }
        if ((elementOrAttribute = matcher.group(3)) == null || (elementOrAttribute = elementOrAttribute.trim()).isEmpty()) {
            logger.error("Could not get the 'elementOrAttribute' from ruleId: " + ruleId);
            return ruleId + ", has failed";
        }
        String nodeType = matcher.group(4);
        if (nodeType == null || nodeType.isEmpty()) {
            logger.error("Could not get the 'nodeType' from ruleId: " + ruleId);
            return ruleId + ", has failed";
        }
        String cardinality = matcher.group(5);
        if (cardinality == null || (cardinality = cardinality.trim()).isEmpty()) {
            logger.error("Could not get the 'cardinality' from ruleId: " + ruleId);
            return ruleId + ", has failed";
        }
        RequirementLevel ruleRequirementLevel = this.getRequirementLevelOf(ruleId);
        String lastMessage = ruleRequirementLevel == RequirementLevel.OPTIONAL || ruleRequirementLevel == RequirementLevel.RECOMMENDED ? (rule instanceof SyntheticRule && this.isRulePopulated((SyntheticRule)rule, nodeType, elementOrAttribute) ? ", has failed" : ", is not populated") : (failureMessage != null && failureMessage.contains("but found 0") ? ", is not populated" : ", has failed");
        return introduction + elementOrAttribute + "'" + nodeType.toLowerCase() + (parentElement != null ? " of the '" + parentElement + "' element" : "") + ", with expected occurrence " + cardinality + lastMessage;
    }

    private String synthesizeFailureMessage(Rule<Document> rule) {
        String failureMessage = this.diagnostics.getLastFailureMessage();
        String message = this.synthesizeMainMessage(rule, failureMessage);
        return message + " (reason: \"" + failureMessage + "\").";
    }

    private String synthesizeNotApplicableMessage(Rule<Document> rule) {
        String message = this.synthesizeMainMessage(rule, null);
        return message + ", is not applicable.";
    }

    void setNodesOf(String ruleId, NodeList nodes) {
        this.ruleIdToNodeList.put(ruleId, nodes);
    }

    NodeList getNodesOf(String ruleId) {
        return this.ruleIdToNodeList.get(ruleId);
    }

    void setRequirementLevelOf(String ruleId, RequirementLevel requirementLevel) {
        this.ruleIdToRequirementLevel.put(ruleId, requirementLevel);
    }

    RequirementLevel getRequirementLevelOf(String ruleId) {
        return this.ruleIdToRequirementLevel.get(ruleId);
    }

    public String toString() {
        return "GuidelineEvaluation{subjectId='" + this.subjectId + '\'' + ", doc=" + this.doc + ", weight=" + this.weight + ", warnings=" + this.warnings + ", errors=" + this.errors + ", ruleIdToRequirementLevel=" + this.ruleIdToRequirementLevel + ", ruleIdToNodeList=" + this.ruleIdToNodeList + ", diagnostics=" + this.diagnostics + ", reporter=" + this.reporter + '}';
    }

    private static final class Diagnostics
    extends StandardRuleDiagnostics<Document, SyntheticRule<Document>> {
        private final Map<String, Status> statusByRuleId = new HashMap<String, Status>();
        private String lastFailureMessage;

        private Diagnostics() {
        }

        @Override
        public void success(SyntheticRule<Document> rule, Document document) {
            OUT.success(rule, document);
            super.success(rule, document);
            this.lastFailureMessage = null;
            this.statusByRuleId.put(rule.getContext().getIdProperty().getValue(), Status.SUCCESS);
        }

        @Override
        public void failure(SyntheticRule<Document> rule, Document document, String message) {
            OUT.failure(rule, document, message);
            super.failure(rule, document, message);
            this.lastFailureMessage = message;
            this.statusByRuleId.put(rule.getContext().getIdProperty().getValue(), Status.FAILURE);
        }

        public String getLastFailureMessage() {
            return this.lastFailureMessage;
        }

        @Override
        public void error(SyntheticRule<Document> rule, Document document, Throwable err) {
            ERR.error(rule, document, err);
            super.error(rule, document, err);
            this.statusByRuleId.put(rule.getContext().getIdProperty().getValue(), Status.ERROR);
        }

        public Status statusFor(String ruleId) {
            return this.statusByRuleId.get(ruleId);
        }

        @Override
        public String toString() {
            return "Diagnostics{statusByRuleId=" + this.statusByRuleId + '}';
        }
    }
}

