/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.StandardValidationResult;
import eu.dnetlib.validator2.validation.guideline.AbstractGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.LiteratureGuidelinesV4Profile;
import eu.dnetlib.validator2.validation.utils.ResultUtils;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class I1M_SPEC_LIT
extends AbstractGuideline<Document> {
    private static final Logger logger = LoggerFactory.getLogger(I1M_SPEC_LIT.class);

    public I1M_SPEC_LIT() {
        super("(meta)data use a formal, accessible, shared, and broadly applicable language for knowledge representation", "I1", "description", "https://w3id.org/fair/principles/latest/I1", "I", 1, RequirementLevel.MANDATORY);
    }

    public StandardResult validate(String id, Document t) {
        LiteratureGuidelinesV4Profile profile = new LiteratureGuidelinesV4Profile();
        try {
            StandardValidationResult res_F = profile.validate(id, t);
            Map results = res_F.getResults();
            int MaxScoreF4M_SPEC = (int)(res_F.getScore() * (double)this.getWeight() / 100.0);
            StandardResult ress = I1M_SPEC_LIT.getResult(results.entrySet(), MaxScoreF4M_SPEC);
            return new StandardResult(ress.getScore(), ress.getStatus(), ress.getWarnings(), ress.getErrors(), ress.getInternalError());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static StandardResult getResult(Set<Map.Entry<String, StandardResult>> data, int score) {
        return ResultUtils.getNewResult(data, score);
    }
}

