/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.ElementPosition;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public final class I2_01M
extends AbstractOpenAireProfile {
    private static final String[] resourceTypeGeneralValues = new String[]{"Audiovisual", "Collection", "Dataset", "Event", "Image", "InteractiveResource", "Model", "PhysicalObject", "Service", "Software", "Sound", "Text", "Workflow", "Other"};
    private static final String[] rightsURIList = new String[]{"info:eu-repo/semantics/closedAccess", "info:eu-repo/semantics/embargoedAccess", "info:eu-repo/semantics/restrictedAccess", "info:eu-repo/semantics/openAccess"};
    private static final ElementSpec RESOURCE_TYPE_SPEC = Builders.forRecommendedElement("resourceType").withRecommendedAttribute("resourceTypeGeneral", resourceTypeGeneralValues).build();
    private static final ElementSpec SUBJECT_SPEC = Builders.forMandatoryElement("subject", Cardinality.ONE_TO_N).withOptionalAttribute("subjectScheme").withOptionalAttribute("schemeURI").build();
    private static final ElementSpec RIGHTS_SPEC = Builders.forMandatoryIfApplicableElement("rights", Cardinality.ONE_TO_N, AbstractOpenAireProfile.elementIsPresent("rights")).atPosition(ElementPosition.FIRST).withMandatoryAttribute("rightsURI", rightsURIList).build();
    public static SyntheticGuideline I2_01M_1 = SyntheticGuideline.of("Resource Type", 1, RESOURCE_TYPE_SPEC);
    public static SyntheticGuideline I2_01M_2 = SyntheticGuideline.of("Subject", 1, SUBJECT_SPEC);
    public static SyntheticGuideline I2_01M_3 = SyntheticGuideline.of("Rights", 1, RIGHTS_SPEC);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(Arrays.asList(I2_01M_1, I2_01M_2, I2_01M_3));
    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.stream().collect(Collectors.toMap(Guideline::getName, guideline -> guideline));
    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    public I2_01M() {
        super("Metadata uses FAIR-compliant vocabularies");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}

