/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.config;

import eu.dnetlib.validator.service.config.CascadingPropertyLoader;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class ValidatorServiceContextLoaderListener
extends ContextLoaderListener {
    private static Logger logger = Logger.getLogger(ValidatorServiceContextLoaderListener.class);

    public ValidatorServiceContextLoaderListener() {
    }

    public ValidatorServiceContextLoaderListener(WebApplicationContext context) {
        super(context);
    }

    protected WebApplicationContext createWebApplicationContext(ServletContext servletContext) throws BeansException {
        logger.debug((Object)"Creating web application context");
        Properties props = this.loadProperties();
        String repoMode = props.getProperty("services.validator.mode.repo");
        String userMode = props.getProperty("services.validator.mode.user");
        String dnetWorkflow = props.getProperty("services.validator.dnetWorkflow");
        Boolean standaloneMode = Boolean.parseBoolean(props.getProperty("services.validator.mode.standalone"));
        logger.debug((Object)("Dnet workflow enabled: " + dnetWorkflow));
        String serviceMode = "";
        serviceMode = standaloneMode != false ? "standalone" : "IS";
        logger.debug((Object)("Service mode: " + serviceMode));
        XmlWebApplicationContext ctx = new XmlWebApplicationContext();
        ctx.setServletContext(servletContext);
        Object[] springContextCore = new String[]{"classpath*:/eu/dnetlib/validator/service/config/springContext-validator-config.xml", "classpath:META-INF/cxf/cxf.xml", "classpath:META-INF/cxf/cxf-extension-jaxws.xml", "classpath:META-INF/cxf/cxf-servlet.xml", "classpath*:/eu/dnetlib/soap/cxf/applicationContext-eprbuilders.xml", "classpath*:/eu/dnetlib/validator/commons/dao/springContext-validator-dao-datasource.xml", "classpath*:/eu/dnetlib/validator/commons/dao/springContext-validator-dao.xml", "classpath*:/eu/dnetlib/validator/commons/email/springContext-validator-emailer.xml", "classpath*:/eu/dnetlib/validator/service/listeners/springContext-validator-listeners.xml", "classpath*:/eu/dnetlib/validator/service/providers/springContext-validator-providers.xml", "classpath*:/eu/dnetlib/validator/service/springContext-validator-library.xml", "classpath*:/eu/dnetlib/validator/service/springContext-validator-manager.xml", "classpath*:/eu/dnetlib/validator/service/springContext-validator-service-" + serviceMode + ".xml"};
        Object[] springContextForIS = new String[]{"classpath*:/gr/uoa/di/driver/util/springContext-locators.xml", "classpath*:/eu/dnetlib/clients/ws/springContext-locatorFactory.xml", "classpath*:/gr/uoa/di/driver/app/springContext-commons.xml", "classpath*:/gr/uoa/di/driver/app/springContext-lookupFactory.xml", "classpath*:/gr/uoa/di/driver/app/springContext-lookupClients.xml", "classpath*:/gr/uoa/di/driver/app/springContext-registrator.xml", "classpath*:/eu/dnetlib/enabling/hcm/springContext-hcmService.xml", "classpath*:/eu/dnetlib/validator/service/springContext-validator-blackboard.xml"};
        if (standaloneMode.booleanValue()) {
            logger.debug((Object)"Loading contexts for standalone mode");
            ctx.setConfigLocations((String[])springContextCore);
        } else {
            logger.debug((Object)"Loading contexts for dnet");
            ctx.setConfigLocations((String[])ArrayUtils.addAll((Object[])springContextCore, (Object[])springContextForIS));
        }
        ctx.refresh();
        logger.debug((Object)"done");
        return ctx;
    }

    private Properties loadProperties() {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{"classpath*:/eu/dnetlib/validator/service/config/springContext-validator-config.xml"});
        CascadingPropertyLoader pLoader = (CascadingPropertyLoader)ctx.getBean("propertyLoader1");
        Properties props = pLoader.getProperties();
        ctx.destroy();
        ctx.close();
        return props;
    }
}

