package eu.dnetlib.validator.service.impls.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import eu.dnetlib.api.data.DatasourceManagerService;
import eu.dnetlib.validator.commons.dao.jobs.JobsDAO;
import eu.dnetlib.validator.commons.email.Emailer;
import eu.dnetlib.validator.engine.execution.CompletedTask;
import eu.dnetlib.validator.engine.execution.JobListener;
import gr.uoa.di.driver.util.ServiceLocator;

public class RegistrationListener implements JobListener{
	
	private Emailer emailer = null;
	private String valBaseUrl = null;
	private JobsDAO jobsDao;
	private ServiceLocator<DatasourceManagerService> dmService = null;
	
	private static final int BASE_SCORE = 50;
	
	private int jobId;
	private String activationId, userMail, officialName, baseUrl, datasourceId, interfaceId, interfaceIdOld, validationSet, desiredCompLevel, repoType;

	private String msgSubject;
	
	private boolean updateExisting;

	private List<String> adminEmails;
	
	private boolean job1Success = false;
	private boolean job2Success = false; 
	
	private boolean critFailDone = false;
	
	private int totalJobs;
	private int jobsFinished = 0;
	
	private int score_content = 0, score_usage = 0;
	
	private static Logger logger = Logger.getLogger(RegistrationListener.class);
	
	
	public RegistrationListener() {
		logger.debug("Creating a pre-registration listener for job "+jobId + " on repo "+baseUrl);
	}

	public synchronized void jobSuccess(int jobId, int score_content, int score_usage) {
		logger.debug("Preregistration job "+jobId+" finished");
		this.score_content = score_content;
		this.score_usage = score_usage;
		this.jobId=jobId;
		if (score_content >= BASE_SCORE)
			job1Success = true;
		if (score_usage >= BASE_SCORE)
			job2Success = true;
		if (job1Success == job2Success == true) {
			this.criticalSuccess();
		} else {
			if(!critFailDone)
				this.criticalFailure();
			critFailDone = true;
		}
	}

	
	public synchronized void jobFailure(int jobId, String error) {
		logger.debug("Pregistration job "+jobId+" failed with exception: "+error);
		this.jobId=jobId;
		if(!critFailDone)
			this.criticalFailure();
		critFailDone = true;
	}
	
	private void criticalSuccess() {
		try {
			String msgOpenaireV2 = "OpenAIRE v2, please consider to upgrade to OpenAIRE Guidelines v3. Link: https://guidelines.openaire.eu/wiki/OpenAIRE_Guidelines:_For_Literature_repositories";
			String msgDriver = "OpenAIRE Basic (ex DRIVER) Guidelines, please consider to upgrade to OpenAIRE Guidelines v3. Link: https://guidelines.openaire.eu/wiki/OpenAIRE_Guidelines:_For_Literature_repositories";
			String msgOpenaireV3 = "OpenAIRE Guidelines v3 (for literature)";
			String msgOpenaireV2_data = "OpenAIRE Guidelines v2 (for data archives)";
			String msgVersion = msgOpenaireV3;
			String msg100 = "\n\nWe also encourage you to display the following logo at your repository's/journal's homepage to indicate that it is 100% OpenAIRE compliant: " + valBaseUrl + "/jsps/images/compliant.png";
			String msgInformUser = "An email has been send to the repository's/journal's administrators to inform them about this registration";
			String msgInformAdmins = "The " + repoType + " was registered by user: " + userMail + " , who is not listed as repository's/journal's administrator. If you have any concerns, please visit " + valBaseUrl + " to edit your repository's/journal's information. Please Sign in or Register with this email address.";
			String msgGuidelines = "OpenAIRE Guidelines v3 (for literature)";
			logger.debug("Critical Success of pre-registration validations on repo: "+baseUrl+" and set: " + validationSet + " with scores ("+score_content+", "+score_usage+")");
			
			if (this.desiredCompLevel.equalsIgnoreCase("openaire2.0")) {
				msgVersion = msgOpenaireV2;
				msgGuidelines = "OpenAIRE For Literature Repositories (OpenAIRE 2.0)";
			} else if (this.desiredCompLevel.equalsIgnoreCase("driver")) {
				msgVersion = msgDriver;
				msgGuidelines = "OpenAIRE For Literature Repositories (Basic - ex DRIVER)";
			} else if (this.desiredCompLevel.equalsIgnoreCase("openaire2.0_data")) {
				msgVersion = msgOpenaireV2_data;
				msgGuidelines = "OpenAIRE For Data Archives (OpenAIRE 2.0)";
			} else if (this.desiredCompLevel.equalsIgnoreCase("openaire3.0")) {
				msgVersion = msgOpenaireV3;
				msgGuidelines = "OpenAIRE For Literature Repositories (OpenAIRE 3.0)";
			}
			if (score_content == 100 && score_usage == 100)
				emailer.sendMail(this.adminEmails, getMsgSubject() + "- Test Results [" + this.officialName + "]", "Congratulations!! Your " + repoType + " has successfully passed the test to become compliant with " + msgVersion + "." + msg100, false, null);
			else
				emailer.sendMail(this.adminEmails, getMsgSubject() + "- Test Results [" + this.officialName + "]", "Congratulations!! Your " + repoType + " has successfully passed the test to become compliant with " + msgVersion + ".", false, null);
			
			this.updateRepositoryInterfaceCompliance(officialName, datasourceId, interfaceId, desiredCompLevel, validationSet, baseUrl, interfaceIdOld);
						
			// mail to user informing him of the success
			List<String> rec = new ArrayList<String>();
			rec.add(this.userMail);
			if (adminEmails.contains(userMail)) {
				emailer.sendMail(rec, getMsgSubject() + "- Results [" + this.officialName + "]", "The compatibility test of your " + repoType + " was successful. Nevertheless, some erros might still exist. We strongly recommend reviewing the results and correcting any errors found:\n" + valBaseUrl + "/prepareSummary.action?jobId=" + this.jobId +  "\n", false, null);
			}
			else {
				emailer.sendMail(rec, getMsgSubject() + "- Results [" + this.officialName + "]", "The compatibility test of your " + repoType + " was successful. Nevertheless, some erros might still exist. We strongly recommend reviewing the results and correcting any errors found:\n" + valBaseUrl + "/prepareSummary.action?jobId=" + this.jobId +  "\n\n" + msgInformUser, false, null);
				rec.clear();
				rec.addAll(adminEmails);
				emailer.sendMail(rec, getMsgSubject() + "- Results [" + this.officialName + "]", "The compatibility test of your " + repoType + " was successful. Nevertheless, some erros might still exist. We strongly recommend reviewing the results and correcting any errors found:\n" + valBaseUrl + "/prepareSummary.action?jobId=" + this.jobId  + "\n\n" + msgInformAdmins, false, null);
			}
				
			// mail to specials informing them of the new repository
			// registration
			rec.clear();
			if (this.isUpdateExisting())
				emailer.sendMail(rec, getMsgSubject() + "- Results (success) [" + this.officialName + "]", "An OpenAIRE compliant " + repoType + " has been updated." + "\n\nOfficial Name: " + this.officialName + "\n\nBase URL: " + this.baseUrl + "\n\nValidation Set: " + this.validationSet + "\n\nGuidelines: " + msgGuidelines, true, null);
			else
				emailer.sendMail(rec, getMsgSubject() + "- Results (success) [" + this.officialName + "]", "A new " + repoType + " is ready to be added in the OpenAIRE compliant list." + "\n\nOfficial Name: " + this.officialName + "\n\nBase URL: " + this.baseUrl + "\n\nValidation Set: " + this.validationSet + "\n\nGuidelines: " + msgGuidelines, true, null);
			
		} catch (Exception e) {
			logger.error("", e);
		}
	}

	private void criticalFailure() {
		try {
			String msgGuidelines = "OpenAIRE For Literature Repositories (OpenAIRE 3.0)";
			if (this.desiredCompLevel.equalsIgnoreCase("openaire2.0")) {
				msgGuidelines = "OpenAIRE For Literature Repositories (OpenAIRE 2.0)";
			} else if (this.desiredCompLevel.equalsIgnoreCase("driver")) {
				msgGuidelines = "OpenAIRE For Literature Repositories (Basic - ex DRIVER)";
			} else if (this.desiredCompLevel.equalsIgnoreCase("openaire2.0_data")) {
				msgGuidelines = "OpenAIRE For Data Archives (OpenAIRE 2.0)";
			} else if (this.desiredCompLevel.equalsIgnoreCase("openaire3.0")) {
				msgGuidelines = "OpenAIRE For Literature Repositories (OpenAIRE 3.0)";
			}
			logger.debug("Critical Failure of pre-registration validations on repo "+baseUrl);
			// mail to inform user of failure
			List<String> rec = new ArrayList<String>();
			rec.add(this.userMail);
			emailer.sendMail(rec, getMsgSubject() + "- Results [" + this.officialName + "]", "The compatibility test of your " + repoType + " on repo: "+baseUrl+" and set: " + validationSet + " was unsuccessful and the join process has failed. \n" + "Your Scores: " + score_content + "/100 and " + score_usage + "/100 . Score required to pass: >50 \n" +" Please review the results and correct any errors: \n" + valBaseUrl + "/prepareSummary.action?jobId=" + this.jobId + "\n", false, null);
			emailer.sendMail(new ArrayList<String>(), getMsgSubject() + "- Results (failure) [" + this.officialName + "]", "The compatibility test on "+officialName+" was unsuccessful and the join process has failed. "+ "\n\nOfficial Name: " + this.officialName +  "\n\nBase URL: " + this.baseUrl + "\n\nValidation Set: " + this.validationSet + "\n\nGuidelines: " + msgGuidelines + "\n\nReview the validation results here: \n" + valBaseUrl + "/prepareSummary.action?jobId=" + this.jobId + "\n", true, null);
			
			this.updateRepositoryInterfaceCompliance(officialName, datasourceId, interfaceId, "notCompatible", validationSet, baseUrl, interfaceIdOld);
			
		} catch (Exception e) {
			logger.error("", e);
		}
	}

	@Override
	@Transactional(propagation = Propagation.REQUIRED)
	public synchronized void finished(int jobId, Map<String, Object> jobContext) {
		try{
			jobsFinished++;
			if (jobContext.containsKey("score_content")) {
				score_content = (Integer) jobContext.get("score_content");
			} else if (jobContext.containsKey("score_usage")) {
				score_usage = (Integer) jobContext.get("score_usage");
			}
			if (jobsFinished == totalJobs) {
				logger.debug("all jobs for registration finished");
				jobsDao.setTotalJobFinished(jobId, null, false);
				logger.debug("id:"+jobId+ "c: " + score_content + " u:" + score_usage);
				this.jobSuccess((Integer) jobContext.get("jobSubmittedId"), score_content, score_usage);
			} else {
				logger.debug("not all jobs finished yet. Waiting "+ (totalJobs-jobsFinished) + " job(s) to finish" );
			}
		} catch (Exception e) {
			logger.error("Error while finalizing successfull registration job");
		}
	}
	
	@Override
	@Transactional(propagation = Propagation.REQUIRED)
	public synchronized void failed(int jobId, Map<String, Object> jobContext, Throwable t) {
		try{
			jobsDao.setTotalJobFinished(jobId, t.getMessage(), true);
			this.jobFailure((Integer) jobContext.get("jobSubmittedId"),t.getMessage());	
		} catch (Exception e) {
			logger.error("Error while finalizing failed registration job");
		}
	}
	
	public boolean updateRepositoryInterfaceCompliance(String officialName,
			String datasourceId, String interfaceId, String desiredCompliance, String set, String baseUrl, String oldId)
					throws Exception {
		boolean ret = true;
		try {
			if (desiredCompliance.equalsIgnoreCase("openaire2.0_data"))
				desiredCompliance = "openaire2.0";
			logger.debug("updating repository " + officialName + " compliance to : " + desiredCompliance);
			if (oldId == null) {
				dmService.getService().updateLevelOfCompliance(datasourceId, interfaceId, desiredCompliance);
			}
			else {
				logger.debug("Checking if old interface should be updated");
				if (!desiredCompliance.equalsIgnoreCase("UNKNOWN") && (!desiredCompliance.equalsIgnoreCase("notCompatible"))) {
					logger.debug("updating old interface with new set/url");
					dmService.getService().updateBaseUrl(datasourceId, oldId, baseUrl);
					if(set.equalsIgnoreCase("none"))
						dmService.getService().deleteAccessParamOrExtraField(datasourceId, oldId, "set");
					else
						dmService.getService().updateAccessParam(datasourceId, oldId, "set", set, false);
					logger.debug("deleting new interface");
					dmService.getService().deleteInterface(datasourceId, interfaceId);
					
				}
				logger.debug("updating repository " + officialName + " compliance to : " + desiredCompliance);
			}
			java.util.Date utilDate = new java.util.Date();
			java.sql.Timestamp date = new java.sql.Timestamp(utilDate.getTime());	
			
			String updateQuery = "UPDATE datasources SET activationid = " + null + "," +
					" dateofvalidation = '" + date + "'" +
					" WHERE id = '" + datasourceId + "'";
			
			if (dmService.getService().updateSQL(datasourceId, updateQuery, false))
				logger.debug("updated successfully");
			else
				logger.error("error while updating: " + updateQuery);
			
		} catch (Exception e) {
			logger.error("error connecting to dms to set a repo interface as openaire compliant " + officialName, e);
			ret = false;
			throw e;
		}  	
		return ret;
	}	
	
	public String getMsgSubject() {
		if (isUpdateExisting())
			msgSubject = "Request to update an OpenAIRE " + repoType + " ";
		else 
			msgSubject = "Request to Join OpenAIRE ";
		return msgSubject;
	}

	
	public boolean isUpdateExisting() {
		return updateExisting;
	}

	public void setUpdateExisting(boolean updateExisting) {
		this.updateExisting = updateExisting;
	}
	
	public Emailer getEmailer() {
		return emailer;
	}

	public void setEmailer(Emailer emailer) {
		this.emailer = emailer;
	}

	public String getValBaseUrl() {
		return valBaseUrl;
	}

	public void setValBaseUrl(String valBaseUrl) {
		this.valBaseUrl = valBaseUrl;
	}

	public String getActivationId() {
		return activationId;
	}


	public void setActivationId(String activationId) {
		this.activationId = activationId;
	}


	public String getUserMail() {
		return userMail;
	}


	public void setUserMail(String userMail) {
		this.userMail = userMail;
	}


	public String getOfficialName() {
		return officialName;
	}


	public void setOfficialName(String officialName) {
		this.officialName = officialName;
	}


	public String getBaseUrl() {
		return baseUrl;
	}


	public void setBaseUrl(String baseUrl) {
		this.baseUrl = baseUrl;
	}

	public String getDatasourceId() {
		return datasourceId;
	}

	public void setDatasourceId(String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getInterfaceId() {
		return interfaceId;
	}

	public void setInterfaceId(String interfaceId) {
		this.interfaceId = interfaceId;
	}

	public String getValidationSet() {
		return validationSet;
	}

	public void setValidationSet(String validationSet) {
		this.validationSet = validationSet;
	}

	public List<String> getAdminEmails() {
		return adminEmails;
	}


	public void setAdminEmails(List<String> adminEmails) {
		this.adminEmails = adminEmails;
	}


	@Override
	public synchronized void currentResults(List<CompletedTask> tasks, int jobId,
			Object object, Map<String, Object> recordContext, Throwable t) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public synchronized void currentResults(List<CompletedTask> tasks, int jobId,
			Object object, Map<String, Object> recordContext) {
		// TODO Auto-generated method stub
		
	}


	public String getDesiredCompLevel() {
		return desiredCompLevel;
	}

	public void setDesiredCompLevel(String desiredCompLevel) {
		this.desiredCompLevel = desiredCompLevel;
	}

	public String getRepoType() {
		return repoType;
	}

	public void setRepoType(String repoType) {
		this.repoType = repoType;
	}

	public String getInterfaceIdOld() {
		return interfaceIdOld;
	}

	public void setInterfaceIdOld(String interfaceIdOld) {
		this.interfaceIdOld = interfaceIdOld;
	}

	public int getTotalJobs() {
		return totalJobs;
	}

	public void setTotalJobs(int totalJobs) {
		this.totalJobs = totalJobs;
	}

	public ServiceLocator<DatasourceManagerService> getDmService() {
		return dmService;
	}

	public void setDmService(ServiceLocator<DatasourceManagerService> dmService) {
		this.dmService = dmService;
	}

	public JobsDAO getJobsDao() {
		return jobsDao;
	}

	public void setJobsDao(JobsDAO jobsDao) {
		this.jobsDao = jobsDao;
	}

}
