/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.listeners;

import eu.dnetlib.validator.engine.execution.CompletedTask;
import eu.dnetlib.validator.engine.execution.JobListener;
import eu.dnetlib.validator.service.impls.executors.JobWorker;
import eu.dnetlib.validator.service.impls.providers.CrisProvider;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import org.apache.log4j.Logger;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Controller;

@Controller
public class CrisListener
implements JobListener {
    private static Logger logger = Logger.getLogger(CrisListener.class);
    private int workersFirstPhase = 0;
    private int workersFinished = 0;
    private int workers;
    private TaskExecutor executor;
    private List<JobWorker> submittersForReferential;
    private CrisProvider provider;
    private CacheManager cacheManager = null;
    private String cacheName = null;

    public void beginCrisReferentialCheck() {
        this.provider.restartResultSets();
        for (JobWorker submiter : this.submittersForReferential) {
            this.executor.execute((Runnable)submiter);
        }
    }

    public void currentResults(List<CompletedTask> tasks, int jobId, Object record, Map<String, Object> recordContext, Throwable t) {
    }

    public void currentResults(List<CompletedTask> tasks, int jobId, Object record, Map<String, Object> recordContext) {
    }

    public synchronized void finished(int jobId, Map<String, Object> jobContext) {
        try {
            ++this.workersFinished;
            if (this.workersFinished == this.workersFirstPhase) {
                logger.debug((Object)"1st phase finished.. Beginning second one..");
                this.beginCrisReferentialCheck();
            }
            if (this.workersFinished == this.workers && this.cacheName != null) {
                this.cacheManager.removeCache(this.cacheName);
                logger.debug((Object)("caches after removal of cache: " + this.cacheName));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while finalizing successful cris job");
        }
    }

    public synchronized void failed(int jobId, Map<String, Object> jobContext, Throwable t) {
        try {
            ++this.workersFinished;
            if (this.workersFinished == this.workers - this.workersFirstPhase && this.cacheName != null) {
                this.cacheManager.removeCache(this.cacheName);
                logger.debug((Object)("caches after removal of cache: " + this.cacheName));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while finalizing failed cris job");
        }
    }

    public void setWorkersFirstPhase(int workersFirstPhase) {
        this.workersFirstPhase = workersFirstPhase;
    }

    public void setWorkers(int workers) {
        this.workers = workers;
    }

    public void setExecutor(TaskExecutor executor) {
        this.executor = executor;
    }

    public void setSubmittersForReferential(List<JobWorker> submittersForReferential) {
        this.submittersForReferential = submittersForReferential;
    }

    public void setProvider(CrisProvider provider) {
        this.provider = provider;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }
}

