/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.rules;

import eu.dnetlib.validator.service.impls.rules.ChainRule;
import eu.dnetlib.validator.service.impls.rules.oaipmh.OAIPMHDateGranularityRule;
import eu.dnetlib.validator.service.impls.rules.oaipmh.OAIPMHEmbargoDateRule;
import eu.dnetlib.validator.service.impls.rules.oaipmh.OAIPMHIncrementalRecordDeliveryRule;
import eu.dnetlib.validator.service.impls.rules.oaipmh.OAIPMHResumptionTokenDurationRule;
import eu.dnetlib.validator.service.impls.rules.xml.XMLCardinalityRule;
import eu.dnetlib.validator.service.impls.rules.xml.XMLCrisClassVocabularyRule;
import eu.dnetlib.validator.service.impls.rules.xml.XMLCrisReferentialIntegrityRule;
import eu.dnetlib.validator.service.impls.rules.xml.XMLFieldExistsRule;
import eu.dnetlib.validator.service.impls.rules.xml.XMLNotConfusedFieldsRule;
import eu.dnetlib.validator.service.impls.rules.xml.XMLRegularExpressionRule;
import eu.dnetlib.validator.service.impls.rules.xml.XMLValidURL;
import eu.dnetlib.validator.service.impls.rules.xml.XMLVocabularyRule;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class RuleTypes {
    private static Logger logger = Logger.getLogger(RuleTypes.class);
    private static HashMap<String, String> types;
    private static HashMap<String, String> entities;

    public static HashMap<String, String> getEntities() {
        return entities;
    }

    public static void setEntities(HashMap<String, String> entities) {
        RuleTypes.entities = entities;
    }

    public static String getSetOfEntity(String entity) {
        return (String)entities.get(entity);
    }

    public static String[] getTypes() {
        logger.debug((Object)"getting all types of rules");
        String[] dummy = new String[]{};
        return types.keySet().toArray(dummy);
    }

    public static String getClassOfType(String type) {
        logger.debug((Object)("getting class of rule type " + type));
        return (String)types.get(type);
    }

    static {
        logger.debug((Object)"initializing the RuleTypes map");
        types = new HashMap();
        types.put("ChainRule", ChainRule.class.getName());
        types.put("OAIPMH Incremental Record Delivery", OAIPMHIncrementalRecordDeliveryRule.class.getName());
        types.put("OAIPMH Date Granularity", OAIPMHDateGranularityRule.class.getName());
        types.put("OAIPMH Resumption Token Duration Check", OAIPMHResumptionTokenDurationRule.class.getName());
        types.put("OAIPMH Embargo Date Check", OAIPMHEmbargoDateRule.class.getName());
        types.put("XML Cardinality", XMLCardinalityRule.class.getName());
        types.put("XML Field Exists", XMLFieldExistsRule.class.getName());
        types.put("XML Not Confused Fields", XMLNotConfusedFieldsRule.class.getName());
        types.put("XML Regular Expression", XMLRegularExpressionRule.class.getName());
        types.put("XML Valid Url", XMLValidURL.class.getName());
        types.put("XML Vocabulary", XMLVocabularyRule.class.getName());
        types.put("XML Cris Class Vocabulary", XMLCrisClassVocabularyRule.class.getName());
        types.put("XML CRIS Referential Integrity Rule", XMLCrisReferentialIntegrityRule.class.getName());
        logger.debug((Object)"initializing the RuleEntities map");
        entities = new HashMap();
        entities.put("Publication", "openaire_cris_publications");
        entities.put("Person", "openaire_cris_persons");
        entities.put("Organisation", "openaire_cris_orgunits");
        entities.put("Project", "openaire_cris_projects");
        entities.put("Funding", "openaire_cris_funding");
        entities.put("Service", "openaire_cris_services");
        entities.put("Product", "openaire_cris_datasets");
    }
}

