/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impl;

import eu.dnetlib.api.functionality.ValidatorService;
import eu.dnetlib.api.functionality.ValidatorServiceException;
import eu.dnetlib.domain.ActionType;
import eu.dnetlib.domain.ResourceType;
import eu.dnetlib.domain.functionality.validator.JobForValidation;
import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.validator.engine.ValidatorException;
import eu.dnetlib.validator.service.impl.ValidatorManager;
import gr.uoa.di.driver.app.DriverServiceImpl;
import gr.uoa.di.driver.enabling.issn.NotificationListener;
import java.util.List;
import org.apache.log4j.Logger;

public class ValidatorServiceImpl
extends DriverServiceImpl
implements ValidatorService {
    private BlackboardNotificationHandler<BlackboardServerHandler> blackboardNotificationHandler = null;
    private Logger logger = Logger.getLogger(ValidatorServiceImpl.class);
    private ValidatorManager valManager;

    public void init() {
        super.init();
        if (this.blackboardNotificationHandler != null) {
            this.subscribe(ActionType.UPDATE, ResourceType.VALIDATORSERVICERESOURCETYPE, this.getServiceEPR().getParameter("serviceId"), "RESOURCE_PROFILE/BODY/BLACKBOARD/LAST_REQUEST", (NotificationListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public StoredJob getStoredJob(int jobId, String groupBy) throws ValidatorServiceException {
        try {
            this.logger.info((Object)("received request for job " + jobId));
            return this.valManager.getStoredJob(jobId, groupBy);
        }
        catch (ValidatorException e) {
            throw new ValidatorServiceException((Throwable)e);
        }
    }

    public List<StoredJob> getStoredJobs(String userMail, String jobType, Integer offset, Integer limit, String dateFrom, String dateTo) throws ValidatorServiceException {
        try {
            this.logger.debug((Object)("received request for jobs of user " + userMail));
            return this.valManager.getStoredJobs(userMail, jobType, offset, limit, dateFrom, dateTo);
        }
        catch (ValidatorException e) {
            throw new ValidatorServiceException((Throwable)e);
        }
    }

    public List<StoredJob> getStoredJobsNew(String userMail, String jobType, Integer offset, Integer limit, String dateFrom, String dateTo, String jobStatus) throws ValidatorServiceException {
        try {
            this.logger.debug((Object)("received request for jobs of user " + userMail));
            return this.valManager.getStoredJobs(userMail, jobType, offset, limit, dateFrom, dateTo, jobStatus);
        }
        catch (ValidatorException e) {
            throw new ValidatorServiceException((Throwable)e);
        }
    }

    public int getStoredJobsTotalNumber(String userMail, String jobType) throws ValidatorServiceException {
        try {
            this.logger.debug((Object)("received request for total number of jobs of user " + userMail));
            return this.valManager.getStoredJobsTotalNumber(userMail, jobType);
        }
        catch (ValidatorException e) {
            throw new ValidatorServiceException((Throwable)e);
        }
    }

    public int getStoredJobsTotalNumberNew(String userMail, String jobType, String jobStatus) throws ValidatorServiceException {
        try {
            this.logger.debug((Object)("received request for total number of jobs of user " + userMail));
            return this.valManager.getStoredJobsTotalNumber(userMail, jobType, jobStatus);
        }
        catch (ValidatorException e) {
            throw new ValidatorServiceException((Throwable)e);
        }
    }

    public List<RuleSet> getRuleSets() throws ValidatorServiceException {
        try {
            this.logger.info((Object)"received request for rulesets ");
            return this.valManager.getRuleSets();
        }
        catch (ValidatorException e) {
            throw new ValidatorServiceException((Throwable)e);
        }
    }

    public void submitValidationJob(JobForValidation job) throws ValidatorServiceException {
        try {
            this.logger.info((Object)"received request to submit job");
            this.valManager.submitJob(job);
        }
        catch (ValidatorException e) {
            throw new ValidatorServiceException((Throwable)e);
        }
    }

    public BlackboardNotificationHandler<BlackboardServerHandler> getBlackboardNotificationHandler() {
        return this.blackboardNotificationHandler;
    }

    public ValidatorManager getValManager() {
        return this.valManager;
    }

    public void setValManager(ValidatorManager valManager) {
        this.valManager = valManager;
    }

    public void setBlackboardNotificationHandler(BlackboardNotificationHandler<BlackboardServerHandler> blackboardNotificationHandler) {
        this.blackboardNotificationHandler = blackboardNotificationHandler;
    }

    static /* synthetic */ BlackboardNotificationHandler access$000(ValidatorServiceImpl x0) {
        return x0.blackboardNotificationHandler;
    }

    static /* synthetic */ Logger access$100(ValidatorServiceImpl x0) {
        return x0.logger;
    }
}

